/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Date;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.PrimitiveTypeProperties;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.NilReason;

public final class MetadataUtilities
extends Static {
    private MetadataUtilities() {
    }

    public static long toMilliseconds(Date value) {
        return value != null ? value.getTime() : Long.MIN_VALUE;
    }

    public static Date toDate(long value) {
        return value != Long.MIN_VALUE ? new Date(value) : null;
    }

    public static boolean getInclusion(Boolean value) throws InvalidMetadataException {
        if (value == null) {
            return true;
        }
        boolean p = value;
        if (p || value == Boolean.FALSE || !(PrimitiveTypeProperties.property(value) instanceof NilReason)) {
            return p;
        }
        throw new InvalidMetadataException(Errors.format((short)64, "inclusion"));
    }

    public static boolean ensurePositive(Class<?> classe, String property, boolean strict, Number newValue) throws IllegalArgumentException {
        if (newValue != null) {
            double value = newValue.doubleValue();
            if (!(!strict ? value >= 0.0 : value > 0.0) && NilReason.forObject(newValue) == null) {
                String msg = MetadataUtilities.logOrFormat(classe, property, strict ? (short)132 : 67, property, newValue);
                if (msg != null) {
                    throw new IllegalArgumentException(msg);
                }
                return false;
            }
        }
        return true;
    }

    public static boolean ensureInRange(Class<?> classe, String property, Number minimum, Number maximum, Number newValue) throws IllegalArgumentException {
        double value;
        if (!(newValue == null || (value = newValue.doubleValue()) >= minimum.doubleValue() && value <= maximum.doubleValue() || NilReason.forObject(newValue) != null)) {
            String msg = MetadataUtilities.logOrFormat(classe, property, (short)133, property, minimum, maximum, newValue);
            if (msg != null) {
                throw new IllegalArgumentException(msg);
            }
            return false;
        }
        return true;
    }

    private static String logOrFormat(Class<?> classe, String property, short key, Object ... arguments) {
        Context context = Context.current();
        if (context == null) {
            return Errors.format(key, arguments);
        }
        StringBuilder buffer = new StringBuilder(property.length() + 3).append("set").append(property);
        buffer.setCharAt(3, Character.toUpperCase(buffer.charAt(3)));
        Context.warningOccured(context, classe, buffer.toString(), Errors.class, key, arguments);
        return null;
    }

    public static void propertyAlreadySet(Class<?> classe, String method, String name) throws IllegalStateException {
        Context context = Context.current();
        if (context == null) {
            throw new IllegalStateException(Errors.format((short)19, name));
        }
        Context.warningOccured(context, classe, method, Errors.class, (short)19, name);
    }

    public static String getObjectID(IdentifiedObject object) {
        Context context = Context.current();
        String id = Context.getObjectID(context, object);
        if (id == null && (id = object.getIdentifierMap().getSpecialized(IdentifierSpace.ID)) != null) {
            StringBuilder buffer = new StringBuilder();
            if (!Utilities.appendUnicodeIdentifier(buffer, '\u0000', id, ":-", false)) {
                return null;
            }
            id = buffer.toString();
            if (!Context.setObjectForID(context, object, id)) {
                int s = buffer.append('-').length();
                int n = 0;
                do {
                    if (++n == 100) {
                        return null;
                    }
                    id = buffer.append(n).toString();
                    buffer.setLength(s);
                } while (!Context.setObjectForID(context, object, id));
            }
        }
        return id;
    }

    public static void setObjectID(IdentifiedObject object, String id) {
        if ((id = CharSequences.trimWhitespaces(id)) != null && !id.isEmpty()) {
            object.getIdentifierMap().putSpecialized(IdentifierSpace.ID, id);
            Context context = Context.current();
            if (!Context.setObjectForID(context, object, id)) {
                Context.warningOccured(context, object.getClass(), "setID", Errors.class, (short)17, id);
            }
        }
    }
}

