/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;

public final class OtherLocales
extends AbstractCollection<Locale> {
    private final Collection<Locale> languages;

    private OtherLocales(Collection<Locale> languages) {
        this.languages = languages;
    }

    public static Collection<Locale> filter(Collection<Locale> languages) {
        return languages != null ? new OtherLocales(languages) : null;
    }

    @Override
    public int size() {
        int size = this.languages.size();
        if (size != 0) {
            --size;
        }
        return size;
    }

    @Override
    public Iterator<Locale> iterator() {
        Iterator<Locale> it = this.languages.iterator();
        if (it.hasNext()) {
            it.next();
        }
        return it;
    }

    @Override
    public boolean add(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        if (this.languages.isEmpty()) {
            Locale defaultLocale = Locale.getDefault();
            if (defaultLocale.equals(locale)) {
                defaultLocale = Locale.ROOT;
            }
            this.languages.add(defaultLocale);
        }
        return this.languages.add(locale);
    }

    public static Collection<Locale> merge(Locale defaultLocale, Collection<? extends Locale> otherLocales) {
        Collection<Locale> merged;
        if (Containers.isNullOrEmpty(otherLocales)) {
            merged = LegacyPropertyAdapter.asCollection(defaultLocale);
        } else {
            merged = new ArrayList<Locale>(otherLocales.size() + 1);
            if (defaultLocale == null && otherLocales.contains(defaultLocale = Locale.getDefault())) {
                defaultLocale = Locale.ROOT;
            }
            merged.add(defaultLocale);
            merged.addAll(otherLocales);
        }
        return merged;
    }

    public static <T> Collection<T> setFirst(Collection<T> values, T newValue) {
        if (values == null) {
            return LegacyPropertyAdapter.asCollection(newValue);
        }
        if (newValue == null) {
            Iterator<T> it = values.iterator();
            if (it.hasNext()) {
                it.next();
                it.remove();
            }
        } else if (values.isEmpty()) {
            values.add(newValue);
        } else {
            if (!(values instanceof List)) {
                values = new ArrayList<T>(values);
            }
            ((List)values).set(0, newValue);
        }
        return values;
    }
}

