/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.metadata.VerticalDatumTypes;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.OptionalDependency;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class ReferencingServices
extends OptionalDependency {
    public static final double NAUTICAL_MILE = 1852.0;
    public static final double AUTHALIC_RADIUS = 6371007.0;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    public static final String PARAMETERS_KEY = "parameters";
    public static final String OPERATION_TYPE_KEY = "operationType";
    public static final String MT_FACTORY = "mtFactory";
    public static final String CRS_FACTORY = "crsFactory";
    public static final String CS_FACTORY = "csFactory";
    private static final char IDENTIFIER_SEPARATOR = ':';
    private static volatile ReferencingServices instance;

    protected ReferencingServices() {
        super("org.apache.sis.metadata", "sis-referencing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void classpathChanged() {
        Class<ReferencingServices> clazz = ReferencingServices.class;
        synchronized (ReferencingServices.class) {
            super.classpathChanged();
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReferencingServices getInstance() {
        ReferencingServices c = instance;
        if (c != null) return c;
        Class<ReferencingServices> clazz = ReferencingServices.class;
        synchronized (ReferencingServices.class) {
            c = instance;
            if (c != null) return c;
            c = ReferencingServices.getInstance(ReferencingServices.class, "org.apache.sis.metadata", "sis-referencing", "org.apache.sis.internal.referencing.ServicesForMetadata");
            if (c == null) {
                c = new ReferencingServices();
            }
            instance = c;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return c;
        }
    }

    public void setBounds(Envelope envelope, DefaultGeographicBoundingBox target) throws TransformException {
        throw this.moduleNotFound();
    }

    public void setBounds(Envelope envelope, DefaultVerticalExtent target) throws TransformException {
        throw this.moduleNotFound();
    }

    public void setBounds(Envelope envelope, DefaultTemporalExtent target) throws TransformException {
        throw this.moduleNotFound();
    }

    public void setBounds(Envelope envelope, DefaultSpatialTemporalExtent target) throws TransformException {
        throw this.moduleNotFound();
    }

    public void addElements(Envelope envelope, DefaultExtent target) throws TransformException {
        throw this.moduleNotFound();
    }

    public ParameterDescriptor<?> toImplementation(ParameterDescriptor<?> parameter) {
        throw this.moduleNotFound();
    }

    public FormattableObject toFormattableObject(IdentifiedObject object) {
        throw this.moduleNotFound();
    }

    public FormattableObject toFormattableObject(MathTransform object, boolean internal) {
        throw this.moduleNotFound();
    }

    public VerticalCRS getMSLH() {
        throw this.moduleNotFound();
    }

    public PrimeMeridian getGreenwich() {
        throw this.moduleNotFound();
    }

    public CartesianCS getGeocentricCS(Unit<Length> unit) {
        throw this.moduleNotFound();
    }

    public CartesianCS upgradeGeocentricCS(CartesianCS cs) {
        return cs;
    }

    public CoordinateSystem createAbstractCS(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        throw this.moduleNotFound();
    }

    public CoordinateSystem createParametricCS(Map<String, ?> properties, CoordinateSystemAxis axis, CSFactory factory) throws FactoryException {
        throw this.moduleNotFound();
    }

    public Datum createParametricDatum(Map<String, ?> properties, DatumFactory factory) throws FactoryException {
        throw this.moduleNotFound();
    }

    public SingleCRS createParametricCRS(Map<String, ?> properties, Datum datum, CoordinateSystem cs, CRSFactory factory) throws FactoryException {
        throw this.moduleNotFound();
    }

    public DerivedCRS createDerivedCRS(Map<String, ?> properties, SingleCRS baseCRS, OperationMethod method, MathTransform baseToDerived, CoordinateSystem derivedCS) {
        throw this.moduleNotFound();
    }

    public final CoordinateReferenceSystem createCompoundCRS(CRSFactory crsFactory, CSFactory csFactory, Map<String, ?> properties, CoordinateReferenceSystem ... components) throws FactoryException {
        for (int i = 0; i < components.length; ++i) {
            VerticalDatum datum;
            CoordinateReferenceSystem vertical = components[i];
            if (!(vertical instanceof VerticalCRS) || (datum = ((VerticalCRS)vertical).getDatum()) == null || datum.getVerticalDatumType() != VerticalDatumTypes.ELLIPSOIDAL) continue;
            int axisPosition = 0;
            EllipsoidalCS cs = null;
            CoordinateReferenceSystem crs = null;
            if (i == 0 || (cs = ReferencingServices.getCsIfGeographic2D(crs = components[i - 1])) == null) {
                if (i + 1 >= components.length || (cs = ReferencingServices.getCsIfGeographic2D(crs = components[i + 1])) == null) continue;
                axisPosition = 1;
            }
            CoordinateSystemAxis[] axes = new CoordinateSystemAxis[3];
            axes[axisPosition++] = cs.getAxis(0);
            axes[axisPosition++] = cs.getAxis(1);
            axes[axisPosition %= 3] = vertical.getCoordinateSystem().getAxis(0);
            cs = csFactory.createEllipsoidalCS(this.getProperties(cs), axes[0], axes[1], axes[2]);
            crs = crsFactory.createGeographicCRS(components.length == 2 ? properties : this.getProperties(crs), ((GeodeticCRS)crs).getDatum(), cs);
            components = ArraysExt.remove(components, i, 1);
            if (axisPosition != 0) {
                --i;
            }
            components[i] = crs;
        }
        switch (components.length) {
            case 0: {
                return null;
            }
            case 1: {
                return components[0];
            }
        }
        return crsFactory.createCompoundCRS(properties, components);
    }

    private static EllipsoidalCS getCsIfGeographic2D(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        if (crs instanceof GeodeticCRS && (cs = crs.getCoordinateSystem()) instanceof EllipsoidalCS && cs.getDimension() == 2) {
            return (EllipsoidalCS)cs;
        }
        return null;
    }

    public AxisDirection directionAlongMeridian(AxisDirection baseDirection, double meridian) {
        throw this.moduleNotFound();
    }

    public Object createToWGS84(double[] values) {
        return null;
    }

    public SingleOperation createSingleOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, CoordinateOperationFactory factory) throws FactoryException {
        throw this.moduleNotFound();
    }

    public CoordinateOperationFactory getCoordinateOperationFactory(Map<String, ?> properties, MathTransformFactory mtFactory, CRSFactory crsFactory, CSFactory csFactory) {
        CoordinateOperationFactory factory = DefaultFactories.forClass(CoordinateOperationFactory.class);
        if (factory != null) {
            return factory;
        }
        throw this.moduleNotFound();
    }

    public Map<String, ?> getProperties(IdentifiedObject object) {
        return Collections.singletonMap("name", object.getName());
    }

    public boolean isHeuristicMatchForName(IdentifiedObject object, String name) {
        return NameToIdentifier.isHeuristicMatchForName(object.getName(), object.getAlias(), name, NameToIdentifier.Simplifier.DEFAULT);
    }

    private boolean matches(OperationMethod method, String identifier) {
        if (this.isHeuristicMatchForName(method, identifier)) {
            return true;
        }
        int s = identifier.indexOf(58);
        while (s >= 0) {
            String codespace = identifier.substring(0, s).trim();
            String code = identifier.substring(++s).trim();
            for (ReferenceIdentifier id : method.getIdentifiers()) {
                if (!codespace.equalsIgnoreCase(id.getCodeSpace()) || !code.equalsIgnoreCase(id.getCode())) continue;
                return true;
            }
            s = identifier.indexOf(58, s);
        }
        return false;
    }

    public final OperationMethod getOperationMethod(Iterable<? extends OperationMethod> methods, String identifier) {
        OperationMethod fallback = null;
        for (OperationMethod operationMethod : methods) {
            if (!this.matches(operationMethod, identifier)) continue;
            if (!(operationMethod instanceof Deprecable) || !((Deprecable)((Object)operationMethod)).isDeprecated()) {
                return operationMethod;
            }
            if (fallback != null) continue;
            fallback = operationMethod;
        }
        return fallback;
    }

    public OperationMethod getOperationMethod(CoordinateOperationFactory opFactory, MathTransformFactory mtFactory, String identifier) throws FactoryException {
        OperationMethod method = this.getOperationMethod(mtFactory.getAvailableMethods(SingleOperation.class), identifier);
        if (method != null) {
            return method;
        }
        throw new NoSuchIdentifierException(Errors.format((short)179, identifier), identifier);
    }

    public String getInformation(String key, Locale locale) {
        return null;
    }
}

