/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.sql.Initializer;
import org.apache.sis.internal.simple.CitationConstant;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;

public final class ServicesForUtility
extends MetadataServices {
    @Override
    public CitationConstant getCitationConstant(String name) {
        Citation c = Citations.fromName(name);
        return c instanceof CitationConstant ? (CitationConstant)c : null;
    }

    @Override
    public Citation createCitation(String key) {
        String title;
        String alternateTitle = null;
        String edition = null;
        String code = null;
        String codeSpace = null;
        String version = null;
        Identifier[] alternateIdentifiers = null;
        String citedResponsibleParty = null;
        PresentationForm presentationForm = null;
        Citation[] copyFrom = null;
        if (key.equals("ISO 19115-1")) {
            title = "Geographic Information \u2014 Metadata Part 1: Fundamentals";
            edition = "ISO 19115-1:2014(E)";
            code = "19115-1";
            codeSpace = "ISO";
            version = "2014(E)";
            citedResponsibleParty = "International Organization for Standardization";
            presentationForm = PresentationForm.DOCUMENT_DIGITAL;
        } else if (key.equals("ISO 19115-2")) {
            title = "Geographic Information \u2014 Metadata Part 2: Extensions for imagery and gridded data";
            edition = "ISO 19115-2:2009(E)";
            code = "19115-2";
            codeSpace = "ISO";
            version = "2009(E)";
            copyFrom = new Citation[]{Citations.ISO_19115.get(0)};
            presentationForm = PresentationForm.DOCUMENT_DIGITAL;
        } else if (key.equals("WMS")) {
            title = "Web Map Server";
            alternateTitle = "Geographic Information \u2014 Web map server interface";
            alternateIdentifiers = new Identifier[]{new ImmutableIdentifier(null, "OGC", "06-042", null, null), new ImmutableIdentifier(null, "ISO", "19128", "2005", null)};
            edition = "1.3";
            code = "WMS";
            codeSpace = "OGC";
            copyFrom = new Citation[]{Citations.OGC, Citations.ISO_19115.get(0)};
            presentationForm = PresentationForm.DOCUMENT_DIGITAL;
        } else if (key.equals("OGC")) {
            title = "Identifiers in OGC namespace";
            code = "OGC";
            citedResponsibleParty = "Open Geospatial Consortium";
            presentationForm = PresentationForm.DOCUMENT_DIGITAL;
        } else if (key.equals("IOGP")) {
            title = "Using the EPSG Geodetic Parameter Dataset";
            code = "IOGP";
            copyFrom = new Citation[]{Citations.EPSG};
            presentationForm = PresentationForm.DOCUMENT_DIGITAL;
        } else if (key.equals("EPSG")) {
            title = "EPSG Geodetic Parameter Dataset";
            code = "EPSG";
            codeSpace = "IOGP";
            citedResponsibleParty = "International Association of Oil & Gas producers";
            presentationForm = PresentationForm.TABLE_DIGITAL;
        } else if (key.equals("SIS")) {
            title = "Apache Spatial Information System";
            code = key;
        } else if (key.equals("ISBN")) {
            title = "International Standard Book Number";
            alternateTitle = key;
        } else if (key.equals("ISSN")) {
            title = "International Standard Serial Number";
            alternateTitle = key;
        } else if (key.equals("Proj4")) {
            title = "Proj.4";
        } else if (key.equals("S57")) {
            title = "S-57";
        } else {
            return super.createCitation(key);
        }
        DefaultCitation c = new DefaultCitation(title);
        if (alternateTitle != null) {
            c.setAlternateTitles(Collections.singleton(Types.toInternationalString(alternateTitle)));
        }
        if (edition != null) {
            c.setEdition(Types.toInternationalString(edition));
        }
        if (code != null) {
            c.setIdentifiers(Collections.singleton(new ImmutableIdentifier(null, codeSpace, code, version, null)));
        }
        if (presentationForm != null) {
            c.setPresentationForms(Collections.singleton(presentationForm));
        }
        if (citedResponsibleParty != null) {
            DefaultResponsibleParty r = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
            r.setParties(Collections.singleton(new DefaultOrganisation(citedResponsibleParty, null, null, null)));
            c.setCitedResponsibleParties(Collections.singleton(r));
        }
        if (copyFrom != null) {
            for (Citation other : copyFrom) {
                Collection<? extends ResponsibleParty> parties = other.getCitedResponsibleParties();
                Collection<ResponsibleParty> current = c.getCitedResponsibleParties();
                if (current != null) {
                    current.addAll(parties);
                    continue;
                }
                c.setCitedResponsibleParties(parties);
            }
        }
        if (alternateIdentifiers != null) {
            c.getIdentifiers().addAll(Arrays.asList(alternateIdentifiers));
        }
        c.freeze();
        return c;
    }

    @Override
    public String getInformation(String key, Locale locale) {
        if (key.equals("DataSource")) {
            Object server = null;
            Object database = null;
            try {
                DataSource ds = Initializer.getDataSource();
                if (ds != null) {
                    Class<?> type = ds.getClass();
                    database = type.getMethod("getDatabaseName", null).invoke((Object)ds, (Object[])null);
                    server = type.getMethod("getServerName", null).invoke((Object)ds, (Object[])null);
                }
            }
            catch (NoSuchMethodException e) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), MetadataServices.class, "getInformation", e);
            }
            catch (Exception e) {
                String message = Exceptions.getLocalizedMessage(e, locale);
                if (message == null || message.indexOf(32) < 0) {
                    message = Classes.getShortClassName(e) + ": " + message;
                }
                return message;
            }
            if (database != null) {
                if (server != null) {
                    database = "//" + server + '/' + database;
                }
                return database.toString();
            }
            return null;
        }
        return ReferencingServices.getInstance().getInformation(key, locale);
    }
}

