/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collections;
import javax.measure.unit.SI;
import org.apache.sis.internal.metadata.RecordSchemaSIS;
import org.apache.sis.metadata.iso.quality.DefaultAbsoluteExternalPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultQuantitativeResult;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.DefaultRecord;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.util.InternationalString;
import org.opengis.util.RecordType;

public final class TransformationAccuracy
extends Static {
    private static final InternationalString TRANSFORMATION_ACCURACY = Vocabulary.formatInternational((short)81);
    private static final RecordType TYPE = RecordSchemaSIS.INSTANCE.createRecordType("Real", Collections.singletonMap(Vocabulary.formatInternational((short)60), Double.class));
    private static final WeakValueHashMap<Double, PositionalAccuracy> CACHE = new WeakValueHashMap(Double.class);

    private TransformationAccuracy() {
    }

    public static PositionalAccuracy create(Double accuracy) {
        PositionalAccuracy p = CACHE.get(accuracy);
        if (p == null) {
            DefaultRecord record = new DefaultRecord(TYPE);
            record.setAll(accuracy);
            DefaultQuantitativeResult result = new DefaultQuantitativeResult();
            result.setValues(Collections.singletonList(record));
            result.setValueUnit(SI.METRE);
            result.setValueType(TYPE);
            DefaultAbsoluteExternalPositionalAccuracy element = new DefaultAbsoluteExternalPositionalAccuracy(result);
            element.setNamesOfMeasure(Collections.singleton(TRANSFORMATION_ACCURACY));
            element.setEvaluationMethodType(EvaluationMethodType.DIRECT_EXTERNAL);
            element.freeze();
            p = CACHE.putIfAbsent(accuracy, element);
            if (p == null) {
                p = element;
            }
        }
        return p;
    }
}

