/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.apache.sis.internal.jdk7.Files;
import org.apache.sis.internal.jdk7.Path;
import org.apache.sis.internal.jdk7.Paths;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.Shutdown;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;

public abstract class Initializer {
    private static final String DATABASE = "SpatialMetadata";
    private static final String DERBY_HOME_KEY = "derby.system.home";
    public static final String JNDI = "jdbc/SpatialMetadata";
    private static URLClassLoader javadbLoader;
    private static DataSource source;

    protected Initializer() {
    }

    protected abstract void createSchema(Connection var1) throws SQLException;

    protected abstract void dataSourceChanged();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DataSource getDataSource() throws Exception {
        if (source == null) {
            boolean create;
            Path path;
            if (Initializer.hasJNDI()) {
                try {
                    Context env = (Context)InitialContext.doLookup("java:comp/env");
                    source = (DataSource)env.lookup(JNDI);
                    if (env instanceof EventContext) {
                        Listener.register((EventContext)env);
                    }
                    return source;
                }
                catch (NameNotFoundException e) {
                    LogRecord record = Messages.getResources(null).getLogRecord(Level.CONFIG, (short)32, JNDI);
                    record.setLoggerName("org.apache.sis.sql");
                    Logging.log(Initializer.class, "getDataSource", record);
                }
            }
            String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(Initializer.DERBY_HOME_KEY);
                }
            });
            Path dir = DataDirectory.DATABASES.getDirectory();
            if (dir != null) {
                path = dir.resolve(DATABASE);
                if (home != null) {
                    try {
                        path = Paths.get(home, new String[0]).relativize(path);
                    }
                    catch (Exception e) {
                        Logging.recoverableException(Logging.getLogger("org.apache.sis.sql"), Initializer.class, "getDataSource", e);
                    }
                }
                create = !Files.exists(path = path.normalize());
                source = Initializer.forJavaDB(path.toString());
            } else if (home != null) {
                path = Paths.get(home, new String[0]);
                create = !Files.exists(path.resolve(DATABASE)) && Files.isDirectory(path);
                source = Initializer.forJavaDB(DATABASE);
            } else {
                return null;
            }
            Shutdown.register(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Initializer.shutdown();
                    return null;
                }
            });
            if (create) {
                Method m = source.getClass().getMethod("setCreateDatabase", String.class);
                m.invoke((Object)source, "create");
                Connection c = source.getConnection();
                try {
                    for (Initializer init : ServiceLoader.load(Initializer.class)) {
                        init.createSchema(c);
                    }
                }
                catch (Throwable throwable) {
                    c.close();
                    m.invoke((Object)source, "no");
                    throw throwable;
                }
                c.close();
                m.invoke((Object)source, "no");
            }
        }
        return source;
    }

    public static boolean hasJNDI() {
        return NamingManager.hasInitialContextFactoryBuilder() || AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return System.getProperty("java.naming.factory.initial") != null;
            }
        }) != false;
    }

    public static String unspecified(Locale locale) {
        String value;
        short key;
        if (Initializer.hasJNDI()) {
            key = 32;
            value = JNDI;
        } else {
            key = 22;
            value = "SIS_DATA";
        }
        return Messages.getResources(locale).getString(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataSource forJavaDB(String path) throws Exception {
        try {
            return Initializer.forJavaDB(path, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            Class<Initializer> clazz = Initializer.class;
            synchronized (Initializer.class) {
                Path file;
                String home;
                URLClassLoader loader = javadbLoader;
                if (loader == null && (home = System.getProperty("java.home")) != null && Files.isRegularFile(file = Paths.get(home, new String[0]).resolveSibling("db/lib/derby.jar"))) {
                    javadbLoader = loader = new URLClassLoader(new URL[]{file.toUri().toURL()});
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (loader == null) {
                    throw e;
                }
                return Initializer.forJavaDB(path, loader);
            }
        }
    }

    private static DataSource forJavaDB(String path, ClassLoader loader) throws Exception {
        Class<?> c = Class.forName("org.apache.derby.jdbc.EmbeddedDataSource", true, loader);
        DataSource ds = (DataSource)c.newInstance();
        Class[] args = new Class[]{String.class};
        c.getMethod("setDatabaseName", args).invoke((Object)ds, path);
        c.getMethod("setDataSourceName", args).invoke((Object)ds, "Apache SIS spatial metadata");
        return ds;
    }

    private static synchronized void shutdown() throws Exception {
        DataSource ds = source;
        if (ds != null) {
            source = null;
            ds.getClass().getMethod("setShutdownDatabase", String.class).invoke((Object)ds, "shutdown");
            try {
                ds.getConnection().close();
            }
            catch (SQLException e) {
                LogRecord record = new LogRecord(Level.FINE, e.getLocalizedMessage());
                if (!Initializer.isSuccessfulShutdown(e)) {
                    record.setLevel(Level.WARNING);
                    record.setThrown(e);
                }
                record.setLoggerName("org.apache.sis.sql");
                Logging.log(Initializer.class, "shutdown", record);
            }
        }
    }

    static boolean isSuccessfulShutdown(SQLException e) {
        String state = e.getSQLState();
        return "08006".equals(state) || "XJ004".equals(state);
    }

    private static final class Listener
    implements ObjectChangeListener,
    Callable<Object> {
        private final EventContext context;

        private Listener(EventContext context) {
            this.context = context;
        }

        static void register(EventContext context) throws NamingException {
            Listener listener = new Listener(context);
            context.addNamingListener(Initializer.JNDI, 0, (NamingListener)listener);
            Shutdown.register(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws NamingException {
            Class<Initializer> clazz = Initializer.class;
            synchronized (Initializer.class) {
                this.context.removeNamingListener(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void objectChanged(NamingEvent event) {
            try {
                Class<Initializer> clazz = Initializer.class;
                synchronized (Initializer.class) {
                    source = null;
                    Shutdown.unregister(this);
                    this.context.removeNamingListener(this);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (NamingException e) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), Listener.class, "objectChanged", e);
            }
            {
                for (Initializer init : ServiceLoader.load(Initializer.class)) {
                    init.dataSourceChanged();
                }
                return;
            }
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent event) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.system"), Listener.class, "namingExceptionThrown", event.getException());
            this.objectChanged(null);
        }
    }
}

