/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;

public final class SQLUtilities
extends Static {
    private SQLUtilities() {
    }

    public static String getSimplifiedURL(DatabaseMetaData metadata) throws SQLException {
        int s2;
        String url = metadata.getURL();
        int s1 = url.indexOf(63);
        if (s1 < 0) {
            s1 = url.length();
        }
        if ((s2 = url.indexOf(59)) < 0) {
            s2 = url.length();
        }
        return url.substring(0, Math.min(s1, s2));
    }

    public static String toLikePattern(String identifier) {
        int c;
        boolean isLetterOrDigit = false;
        StringBuilder buffer = new StringBuilder(identifier.length());
        for (int i = 0; i < identifier.length(); i += Character.charCount(c)) {
            c = identifier.codePointAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.appendCodePoint(c);
                isLetterOrDigit = true;
                continue;
            }
            if (isLetterOrDigit) {
                isLetterOrDigit = false;
                buffer.append('%');
                continue;
            }
            int p = buffer.length();
            if (p != 0 && buffer.charAt(p - 1) == '%') continue;
            buffer.appendCodePoint(c != 37 ? c : 95);
        }
        return buffer.toString();
    }

    public static boolean filterFalsePositive(String expected, String actual) {
        return CharSequences.equalsFiltered(expected, actual, Characters.Filter.LETTERS_AND_DIGITS, false);
    }
}

