/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.ArraysExt;

final class GridGeometryInfo
extends GridGeometry {
    private static final Object[] AXIS_TYPES = new Object[]{"Lon", AttributeNames.LONGITUDE, "Lat", AttributeNames.LATITUDE, "Pressure", AttributeNames.VERTICAL, "Height", AttributeNames.VERTICAL, "RunTime", AttributeNames.TIME, "Time", AttributeNames.TIME};
    private final Dimension[] domain;
    private final VariableInfo[] range;

    GridGeometryInfo(Dimension[] domain, VariableInfo[] range) {
        this.domain = domain;
        this.range = range;
    }

    @Override
    public int getSourceDimensions() {
        return this.domain.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.range.length;
    }

    @Override
    public Axis[] getAxes() {
        int targetDim = this.range.length;
        Axis[] axes = new Axis[targetDim];
        while (--targetDim >= 0) {
            int i;
            VariableInfo axis = this.range[targetDim];
            Dimension[] axisDomain = axis.dimensions;
            AttributeNames.Dimension attributeNames = null;
            String type = axis.getAxisType();
            if (type != null) {
                for (i = 0; i < AXIS_TYPES.length; i += 2) {
                    if (!type.equalsIgnoreCase((String)AXIS_TYPES[i])) continue;
                    attributeNames = (AttributeNames.Dimension)AXIS_TYPES[i + 1];
                    break;
                }
            }
            i = 0;
            int[] indices = new int[axisDomain.length];
            int[] sizes = new int[axisDomain.length];
            block2: for (Dimension dimension : axisDomain) {
                int sourceDim = this.domain.length;
                while (--sourceDim >= 0) {
                    if (this.domain[sourceDim] != dimension) continue;
                    indices[i] = sourceDim;
                    sizes[i++] = dimension.length;
                    continue block2;
                }
            }
            axes[targetDim] = new Axis(this, attributeNames, ArraysExt.resize(indices, i), ArraysExt.resize(sizes, i));
        }
        return axes;
    }

    @Override
    protected double coordinateForCurrentAxis(int j, int i) {
        throw new UnsupportedOperationException();
    }
}

