/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.util.List;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.ArraysExt;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;

final class GridGeometryWrapper
extends GridGeometry {
    private final CoordinateSystem netcdfCS;
    private transient CoordinateAxis2D axis2D;

    GridGeometryWrapper(CoordinateSystem cs) {
        this.netcdfCS = cs;
    }

    @Override
    public int getSourceDimensions() {
        return this.netcdfCS.getRankDomain();
    }

    @Override
    public int getTargetDimensions() {
        return this.netcdfCS.getRankRange();
    }

    @Override
    public Axis[] getAxes() {
        List domain = this.netcdfCS.getDomain();
        List range = this.netcdfCS.getCoordinateAxes();
        int targetDim = range.size();
        Axis[] axes = new Axis[targetDim];
        while (--targetDim >= 0) {
            CoordinateAxis axis = (CoordinateAxis)range.get(targetDim);
            List axisDomain = axis.getDimensions();
            AttributeNames.Dimension attributeNames = null;
            AxisType type = axis.getAxisType();
            if (type != null) {
                switch (type) {
                    case Lon: {
                        attributeNames = AttributeNames.LONGITUDE;
                        break;
                    }
                    case Lat: {
                        attributeNames = AttributeNames.LATITUDE;
                        break;
                    }
                    case Pressure: 
                    case Height: {
                        attributeNames = AttributeNames.VERTICAL;
                        break;
                    }
                    case RunTime: 
                    case Time: {
                        attributeNames = AttributeNames.TIME;
                    }
                }
            }
            int i = 0;
            int[] indices = new int[axisDomain.size()];
            int[] sizes = new int[indices.length];
            for (Dimension dimension : axisDomain) {
                int sourceDim = domain.lastIndexOf(dimension);
                if (sourceDim < 0) continue;
                indices[i] = sourceDim;
                sizes[i++] = dimension.getLength();
            }
            this.axis2D = axis instanceof CoordinateAxis2D ? (CoordinateAxis2D)axis : null;
            axes[targetDim] = new Axis(this, attributeNames, ArraysExt.resize(indices, i), ArraysExt.resize(sizes, i));
        }
        this.axis2D = null;
        return axes;
    }

    @Override
    protected double coordinateForCurrentAxis(int j, int i) {
        return this.axis2D != null ? this.axis2D.getCoordValue(j, i) : Double.NaN;
    }
}

