/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Arrays;
import org.apache.sis.geometry.UnmodifiableGeometryException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class DirectPositionView
implements DirectPosition {
    private final double[] ordinates;
    public int offset;
    private final int dimension;

    public DirectPositionView(double[] ordinates, int offset, int dimension) {
        this.ordinates = ordinates;
        this.offset = offset;
        this.dimension = dimension;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public double[] getCoordinate() {
        return Arrays.copyOfRange(this.ordinates, this.offset, this.offset + this.dimension);
    }

    @Override
    public double getOrdinate(int dim) {
        assert (dim >= 0 && dim < this.dimension) : dim;
        return this.ordinates[this.offset + dim];
    }

    @Override
    public void setOrdinate(int dimension, double value) {
        throw new UnmodifiableGeometryException();
    }

    @Override
    public DirectPosition getDirectPosition() {
        return this;
    }
}

