/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.Static;

public final class Formulas
extends Static {
    public static final double LINEAR_TOLERANCE = 0.01;
    public static final double ANGULAR_TOLERANCE = 8.999280057595393E-8;
    public static final double LONGITUDE_MAX = 4.052915431398935E8;
    public static final long JULIAN_YEAR_LENGTH = 31557600000L;
    public static final int MAXIMUM_ITERATIONS = 15;

    private Formulas() {
    }

    public static int pow3(int n) {
        assert (n >= 0 && n <= 19) : n;
        int p = 1;
        while (--n >= 0) {
            p *= 3;
        }
        return p;
    }

    public static boolean isPoleToPole(double ymin, double ymax) {
        return Math.abs(ymin - -90.0) <= 8.999280057595393E-8 && Math.abs(ymax - 90.0) <= 8.999280057595393E-8;
    }

    public static double getAuthalicRadius(double a, double b) {
        if (a != b) {
            double f = 1.0 - b / a;
            double e = Math.sqrt(2.0 * f - f * f);
            return Math.sqrt(0.5 * (a * a + b * b * MathFunctions.atanh(e) / e));
        }
        return a;
    }

    public static double getSemiMinor(double semiMajorAxis, double inverseFlattening) {
        return semiMajorAxis * (1.0 - 1.0 / inverseFlattening);
    }

    public static double getInverseFlattening(double semiMajorAxis, double semiMinorAxis) {
        return semiMajorAxis / (semiMajorAxis - semiMinorAxis);
    }
}

