/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.measure.quantity.Duration;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.Builder;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class GeodeticObjectBuilder
extends Builder<GeodeticObjectBuilder> {
    private String conversionName;
    private OperationMethod method;
    private ParameterValueGroup parameters;
    private CRSFactory crsFactory;
    private CSFactory csFactory;
    private DatumFactory datumFactory;
    private DefaultCoordinateOperationFactory copFactory;

    private CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            this.crsFactory = DefaultFactories.forBuildin(CRSFactory.class);
        }
        return this.crsFactory;
    }

    private CSFactory getCSFactory() {
        if (this.csFactory == null) {
            this.csFactory = DefaultFactories.forBuildin(CSFactory.class);
        }
        return this.csFactory;
    }

    private DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            this.datumFactory = DefaultFactories.forBuildin(DatumFactory.class);
        }
        return this.datumFactory;
    }

    private DefaultCoordinateOperationFactory getCoordinateOperationFactory() {
        if (this.copFactory == null) {
            this.copFactory = CoordinateOperations.factory();
        }
        return this.copFactory;
    }

    public GeodeticObjectBuilder setConversionMethod(String name) throws FactoryException {
        if (this.method != null) {
            throw new IllegalStateException(Errors.format((short)19, "OperationMethod"));
        }
        this.method = this.getCoordinateOperationFactory().getOperationMethod(name);
        this.parameters = this.method.getParameters().createValue();
        return this;
    }

    public GeodeticObjectBuilder setConversionName(String name) {
        this.conversionName = name;
        return this;
    }

    private void ensureConversionMethodSet() {
        if (this.parameters == null) {
            throw new IllegalStateException();
        }
    }

    public GeodeticObjectBuilder setParameter(String name, double value, Unit<?> unit) throws IllegalStateException, ParameterNotFoundException, InvalidParameterValueException {
        this.ensureConversionMethodSet();
        this.parameters.parameter(name).setValue(value, unit);
        return this;
    }

    public GeodeticObjectBuilder setTransverseMercator(boolean isUTM, double latitude, double longitude) throws FactoryException {
        ArgumentChecks.ensureBetween("latitude", -90.0, 90.0, latitude);
        ArgumentChecks.ensureBetween("longitude", -4.052915431398935E8, 4.052915431398935E8, longitude);
        this.setConversionMethod("Transverse Mercator");
        this.setConversionName(TransverseMercator.setParameters(this.parameters, isUTM, latitude, longitude));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectedCRS createProjectedCRS(GeographicCRS baseCRS, CartesianCS derivedCS) throws FactoryException {
        this.ensureConversionMethodSet();
        this.onCreate(false);
        try {
            String name = this.conversionName != null ? this.properties.put("name", this.conversionName) : null;
            Object alias = this.properties.put("alias", null);
            Object identifier = this.properties.put("identifiers", null);
            Conversion conversion = this.getCoordinateOperationFactory().createDefiningConversion(this.properties, this.method, this.parameters);
            this.properties.put("identifiers", identifier);
            this.properties.put("alias", alias);
            if (name != null) {
                this.properties.put("name", name);
            }
            ProjectedCRS projectedCRS = this.getCRSFactory().createProjectedCRS(this.properties, baseCRS, conversion, derivedCS);
            return projectedCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporalCRS createTemporalCRS(Date origin, Unit<Duration> unit) throws FactoryException {
        TimeCS cs = null;
        TemporalDatum datum = null;
        for (CommonCRS.Temporal c : CommonCRS.Temporal.values()) {
            TemporalCRS crs;
            TimeCS candidate;
            TemporalDatum candidate2;
            if (datum == null && origin.equals((candidate2 = c.datum()).getOrigin())) {
                datum = candidate2;
            }
            if (cs != null || !unit.equals((candidate = (crs = c.crs()).getCoordinateSystem()).getAxis(0).getUnit())) continue;
            if (datum == candidate && this.properties.isEmpty()) {
                return crs;
            }
            cs = candidate;
        }
        this.onCreate(false);
        try {
            if (cs == null) {
                CSFactory cSFactory = this.getCSFactory();
                cs = CommonCRS.Temporal.JAVA.crs().getCoordinateSystem();
                cs = cSFactory.createTimeCS(GeodeticObjectBuilder.name(cs), cSFactory.createCoordinateSystemAxis(GeodeticObjectBuilder.name(cs.getAxis(0)), "t", AxisDirection.FUTURE, unit));
            }
            if (this.properties.get("name") == null) {
                this.properties.putAll(GeodeticObjectBuilder.name(cs));
            }
            if (datum == null) {
                Object v = this.properties.remove("remarks");
                Object identifier = this.properties.remove("identifiers");
                datum = this.getDatumFactory().createTemporalDatum(this.properties, origin);
                this.properties.put("identifiers", identifier);
                this.properties.put("remarks", v);
                this.properties.put("name", datum.getName());
            }
            TemporalCRS temporalCRS = this.getCRSFactory().createTemporalCRS(this.properties, datum, cs);
            return temporalCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    public CoordinateReferenceSystem createCompoundCRS(CoordinateReferenceSystem ... components) throws FactoryException {
        return ReferencingServices.getInstance().createCompoundCRS(this.getCRSFactory(), this.getCSFactory(), this.properties, components);
    }

    private static Map<String, Object> name(IdentifiedObject template) {
        return Collections.singletonMap("name", template.getName());
    }
}

