/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.Unit;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;

public final class ReferencingUtilities
extends Static {
    private ReferencingUtilities() {
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        if (primeMeridian == null) {
            return 0.0;
        }
        if (primeMeridian instanceof DefaultPrimeMeridian) {
            return ((DefaultPrimeMeridian)primeMeridian).getGreenwichLongitude(unit);
        }
        return primeMeridian.getAngularUnit().getConverterTo(unit).convert(primeMeridian.getGreenwichLongitude());
    }

    public static Unit<?> getUnit(CoordinateSystem cs) {
        Unit<?> unit = null;
        if (cs != null) {
            int i = cs.getDimension();
            while (--i >= 0) {
                Unit<?> candidate;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null || (candidate = axis.getUnit()) == null) continue;
                if (unit == null) {
                    unit = candidate;
                    continue;
                }
                if (unit.equals(candidate)) continue;
                return null;
            }
        }
        return unit;
    }

    public static int getDimension(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null) {
            return cs.getDimension();
        }
        return 0;
    }

    public static boolean getSingleComponents(Iterable<? extends CoordinateReferenceSystem> source, Collection<? super SingleCRS> addTo) throws ClassCastException {
        boolean sameContent = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : source) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                ReferencingUtilities.getSingleComponents(((CompoundCRS)coordinateReferenceSystem).getComponents(), addTo);
                sameContent = false;
                continue;
            }
            addTo.add((SingleCRS)coordinateReferenceSystem);
        }
        return sameContent;
    }

    public static Ellipsoid getEllipsoidOfGeographicCRS(CoordinateReferenceSystem crs) {
        while (!(crs instanceof GeodeticCRS)) {
            if (crs instanceof CompoundCRS) {
                crs = ((CompoundCRS)crs).getComponents().get(0);
                continue;
            }
            return null;
        }
        if (crs.getCoordinateSystem() instanceof EllipsoidalCS) {
            return ((GeodeticCRS)crs).getDatum().getEllipsoid();
        }
        return null;
    }

    public static GeographicCRS toNormalizedGeographicCRS(CoordinateReferenceSystem crs) {
        while (crs instanceof GeneralDerivedCRS) {
            crs = ((GeneralDerivedCRS)crs).getBaseCRS();
        }
        if (crs instanceof GeodeticCRS) {
            if (crs instanceof DefaultGeographicCRS && crs.getCoordinateSystem().getDimension() == 2) {
                return ((DefaultGeographicCRS)crs).forConvention(AxesConvention.NORMALIZED);
            }
            EllipsoidalCS cs = CommonCRS.defaultGeographic().getCoordinateSystem();
            if (crs instanceof GeographicCRS && Utilities.equalsIgnoreMetadata(cs, crs.getCoordinateSystem())) {
                return (GeographicCRS)crs;
            }
            return new DefaultGeographicCRS(Collections.singletonMap("name", NilReferencingObject.UNNAMED), ((GeodeticCRS)crs).getDatum(), cs);
        }
        if (crs instanceof CompoundCRS) {
            for (CoordinateReferenceSystem e : ((CompoundCRS)crs).getComponents()) {
                GeographicCRS candidate = ReferencingUtilities.toNormalizedGeographicCRS(e);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Map<String, ?> getPropertiesForModifiedCRS(IdentifiedObject object, String ... excludes) {
        String name;
        Map<String, ?> properties = IdentifiedObjects.getProperties(object, excludes);
        Identifier id = (Identifier)properties.get("name");
        if (id != null && (name = id.getCode()) != null) {
            int c;
            for (int i = 0; i < name.length(); i += Character.charCount(c)) {
                String extra;
                int endAt;
                c = name.codePointAt(i);
                if (Character.isUnicodeIdentifierPart(c) || Character.isSpaceChar(c)) continue;
                if (c == 40 && (endAt = name.indexOf(41, i)) >= 0 && CharSequences.isUnicodeIdentifier(extra = name.substring(i + 1, endAt))) {
                    i += extra.length() + 2;
                }
                if ((name = CharSequences.trimWhitespaces(name, 0, i).toString()).isEmpty()) continue;
                HashMap copy = new HashMap(properties);
                copy.put("name", name);
                return copy;
            }
        }
        return properties;
    }

    public static StringBuilder toPropertyName(Class<?> base, Class<?> type) {
        String name;
        int length;
        StringBuilder buffer;
        UML uml = type.getAnnotation(UML.class);
        if (uml != null && uml.specification() == Specification.ISO_19111 && (buffer = new StringBuilder(length = (name = uml.identifier()).length()).append(name, name.indexOf(95) + 1, length)).length() != 0) {
            buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
            return buffer;
        }
        for (Class<?> c : type.getInterfaces()) {
            StringBuilder name2;
            if (!base.isAssignableFrom(c) || (name2 = ReferencingUtilities.toPropertyName(base, c)) == null) continue;
            return name2;
        }
        return null;
    }

    public static DefaultMathTransformFactory.Context createTransformContext(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, DefaultMathTransformFactory.Context context) {
        CoordinateSystem targetCS;
        if (context == null) {
            context = new DefaultMathTransformFactory.Context();
        }
        CoordinateSystem sourceCS = sourceCRS != null ? sourceCRS.getCoordinateSystem() : null;
        CoordinateSystem coordinateSystem = targetCS = targetCRS != null ? targetCRS.getCoordinateSystem() : null;
        if (sourceCRS instanceof GeodeticCRS && sourceCS instanceof EllipsoidalCS) {
            context.setSource((EllipsoidalCS)sourceCS, ((GeodeticCRS)sourceCRS).getDatum().getEllipsoid());
        } else {
            context.setSource(sourceCS);
        }
        if (targetCRS instanceof GeodeticCRS && targetCS instanceof EllipsoidalCS) {
            context.setTarget((EllipsoidalCS)targetCS, ((GeodeticCRS)targetCRS).getDatum().getEllipsoid());
        } else {
            context.setTarget(targetCS);
        }
        return context;
    }
}

