/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.Legacy;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public final class ServicesForMetadata
extends ReferencingServices {
    public static final String CONNECTION = "CONNECTION";

    private static String dimensionNotFound(short errorKey, CoordinateReferenceSystem crs) {
        if (crs == null) {
            return Errors.format((short)173);
        }
        return Errors.format(errorKey, crs.getName());
    }

    private void setGeographicExtent(Envelope envelope, DefaultGeographicBoundingBox target, CoordinateReferenceSystem crs, GeographicCRS normalizedCRS) throws TransformException {
        if (normalizedCRS != null) {
            CoordinateSystem cs1 = crs.getCoordinateSystem();
            EllipsoidalCS cs2 = normalizedCRS.getCoordinateSystem();
            if (!Utilities.equalsIgnoreMetadata(cs2.getAxis(0), cs1.getAxis(0)) || !Utilities.equalsIgnoreMetadata(cs2.getAxis(1), cs1.getAxis(1))) {
                CoordinateOperation operation;
                DefaultCoordinateOperationFactory factory = CoordinateOperations.factory();
                try {
                    operation = factory.createOperation(crs, normalizedCRS);
                }
                catch (FactoryException e) {
                    throw new TransformException(Errors.format((short)174), e);
                }
                envelope = Envelopes.transform(operation, envelope);
            }
        }
        double westBoundLongitude = envelope.getMinimum(0);
        double eastBoundLongitude = envelope.getMaximum(0);
        double southBoundLatitude = envelope.getMinimum(1);
        double northBoundLatitude = envelope.getMaximum(1);
        if (normalizedCRS != null) {
            double rotation = CRS.getGreenwichLongitude(normalizedCRS);
            westBoundLongitude += rotation;
            eastBoundLongitude += rotation;
        }
        target.setBounds(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude);
        target.setInclusion(Boolean.TRUE);
    }

    private static void setVerticalExtent(Envelope envelope, DefaultVerticalExtent target, CoordinateReferenceSystem crs, VerticalCRS verticalCRS) {
        int dim;
        if (verticalCRS == null) {
            dim = 0;
        } else {
            dim = AxisDirections.indexOfColinear(crs.getCoordinateSystem(), verticalCRS.getCoordinateSystem());
            assert (dim >= 0) : crs;
        }
        target.setMinimumValue(envelope.getMinimum(dim));
        target.setMaximumValue(envelope.getMaximum(dim));
        target.setVerticalCRS(verticalCRS);
    }

    private static void setTemporalExtent(Envelope envelope, DefaultTemporalExtent target, CoordinateReferenceSystem crs, TemporalCRS temporalCRS) {
        int dim = AxisDirections.indexOfColinear(crs.getCoordinateSystem(), temporalCRS.getCoordinateSystem());
        assert (dim >= 0) : crs;
        DefaultTemporalCRS converter = DefaultTemporalCRS.castOrCopy(temporalCRS);
        target.setBounds(converter.toDate(envelope.getMinimum(dim)), converter.toDate(envelope.getMaximum(dim)));
    }

    @Override
    public void setBounds(Envelope envelope, DefaultGeographicBoundingBox target) throws TransformException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        GeographicCRS normalizedCRS = ReferencingUtilities.toNormalizedGeographicCRS(crs);
        if (normalizedCRS == null) {
            if (crs != null) {
                normalizedCRS = CommonCRS.defaultGeographic();
            } else if (envelope.getDimension() != 2) {
                throw new TransformException(ServicesForMetadata.dimensionNotFound((short)169, crs));
            }
        }
        this.setGeographicExtent(envelope, target, crs, normalizedCRS);
    }

    @Override
    public void setBounds(Envelope envelope, DefaultVerticalExtent target) throws TransformException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        VerticalCRS verticalCRS = CRS.getVerticalComponent(crs, true);
        if (verticalCRS == null && envelope.getDimension() != 1) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)172, crs));
        }
        ServicesForMetadata.setVerticalExtent(envelope, target, crs, verticalCRS);
    }

    @Override
    public void setBounds(Envelope envelope, DefaultTemporalExtent target) throws TransformException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        TemporalCRS temporalCRS = CRS.getTemporalComponent(crs);
        if (temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)171, crs));
        }
        ServicesForMetadata.setTemporalExtent(envelope, target, crs, temporalCRS);
    }

    @Override
    public void setBounds(Envelope envelope, DefaultSpatialTemporalExtent target) throws TransformException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        SingleCRS horizontalCRS = CRS.getHorizontalComponent(crs);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(crs, true);
        TemporalCRS temporalCRS = CRS.getTemporalComponent(crs);
        if (horizontalCRS == null && verticalCRS == null && temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)170, crs));
        }
        DefaultGeographicBoundingBox box = null;
        boolean useExistingBox = horizontalCRS != null;
        Collection<GeographicExtent> spatialExtents = target.getSpatialExtent();
        Iterator<GeographicExtent> it = spatialExtents.iterator();
        while (it.hasNext()) {
            GeographicExtent extent = it.next();
            if (!(extent instanceof GeographicBoundingBox)) continue;
            if (useExistingBox && extent instanceof DefaultGeographicBoundingBox) {
                box = (DefaultGeographicBoundingBox)extent;
                useExistingBox = false;
                continue;
            }
            it.remove();
        }
        if (horizontalCRS != null) {
            GeographicCRS normalizedCRS;
            if (box == null) {
                box = new DefaultGeographicBoundingBox();
                spatialExtents.add(box);
            }
            if ((normalizedCRS = ReferencingUtilities.toNormalizedGeographicCRS(crs)) == null) {
                normalizedCRS = CommonCRS.defaultGeographic();
            }
            this.setGeographicExtent(envelope, box, crs, normalizedCRS);
        }
        if (verticalCRS != null) {
            VerticalExtent e = target.getVerticalExtent();
            if (!(e instanceof DefaultVerticalExtent)) {
                e = new DefaultVerticalExtent();
                target.setVerticalExtent(e);
            }
            ServicesForMetadata.setVerticalExtent(envelope, (DefaultVerticalExtent)e, crs, verticalCRS);
        } else {
            target.setVerticalExtent(null);
        }
        if (temporalCRS != null) {
            ServicesForMetadata.setTemporalExtent(envelope, target, crs, temporalCRS);
        } else {
            target.setExtent(null);
        }
    }

    @Override
    public void addElements(Envelope envelope, DefaultExtent target) throws TransformException {
        ISOMetadata extent;
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        SingleCRS horizontalCRS = CRS.getHorizontalComponent(crs);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(crs, true);
        TemporalCRS temporalCRS = CRS.getTemporalComponent(crs);
        if (horizontalCRS == null && verticalCRS == null && temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)170, crs));
        }
        if (horizontalCRS != null) {
            extent = new DefaultGeographicBoundingBox();
            extent.setInclusion(Boolean.TRUE);
            this.setBounds(envelope, (DefaultGeographicBoundingBox)extent);
            target.getGeographicElements().add((GeographicExtent)((Object)extent));
        }
        if (verticalCRS != null) {
            extent = new DefaultVerticalExtent();
            ServicesForMetadata.setVerticalExtent(envelope, (DefaultVerticalExtent)extent, crs, verticalCRS);
            target.getVerticalElements().add((VerticalExtent)((Object)extent));
        }
        if (temporalCRS != null) {
            extent = new DefaultTemporalExtent();
            ServicesForMetadata.setTemporalExtent(envelope, (DefaultTemporalExtent)extent, crs, temporalCRS);
            target.getTemporalElements().add((TemporalExtent)((Object)extent));
        }
    }

    @Override
    public ParameterDescriptor<?> toImplementation(ParameterDescriptor<?> parameter) {
        return DefaultParameterDescriptor.castOrCopy(parameter);
    }

    @Override
    public FormattableObject toFormattableObject(IdentifiedObject object) {
        return AbstractIdentifiedObject.castOrCopy(object);
    }

    @Override
    public FormattableObject toFormattableObject(MathTransform object, boolean internal) {
        ParameterValueGroup parameters;
        Matrix matrix;
        if (internal && (matrix = MathTransforms.getMatrix(object)) != null) {
            parameters = Affine.parameters(matrix);
        } else if (object instanceof Parameterized) {
            parameters = ((Parameterized)((Object)object)).getParameterValues();
        } else {
            matrix = MathTransforms.getMatrix(object);
            if (matrix == null) {
                return null;
            }
            parameters = Affine.parameters(matrix);
        }
        return new FormattableObject(){

            @Override
            protected String formatTo(Formatter formatter) {
                WKTUtilities.appendParamMT(parameters, formatter);
                return "Param_MT";
            }
        };
    }

    @Override
    public VerticalCRS getMSLH() {
        return CommonCRS.Vertical.MEAN_SEA_LEVEL.crs();
    }

    @Override
    public PrimeMeridian getGreenwich() {
        return CommonCRS.WGS84.primeMeridian();
    }

    @Override
    public CartesianCS getGeocentricCS(Unit<Length> linearUnit) {
        return Legacy.standard(linearUnit);
    }

    @Override
    public CartesianCS upgradeGeocentricCS(CartesianCS cs) {
        return Legacy.forGeocentricCRS(cs, false);
    }

    @Override
    public CoordinateSystem createAbstractCS(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        return new AbstractCS(properties, axes);
    }

    @Override
    public CoordinateSystem createParametricCS(Map<String, ?> properties, CoordinateSystemAxis axis, CSFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = DefaultFactories.forBuildin(CSFactory.class, GeodeticObjectFactory.class);
        }
        return ((GeodeticObjectFactory)factory).createParametricCS(properties, axis);
    }

    @Override
    public Datum createParametricDatum(Map<String, ?> properties, DatumFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = DefaultFactories.forBuildin(DatumFactory.class, GeodeticObjectFactory.class);
        }
        return ((GeodeticObjectFactory)factory).createParametricDatum(properties);
    }

    @Override
    public SingleCRS createParametricCRS(Map<String, ?> properties, Datum datum, CoordinateSystem cs, CRSFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = DefaultFactories.forBuildin(CRSFactory.class, GeodeticObjectFactory.class);
        }
        try {
            return ((GeodeticObjectFactory)factory).createParametricCRS(properties, (DefaultParametricDatum)datum, (DefaultParametricCS)cs);
        }
        catch (ClassCastException e) {
            throw new InvalidGeodeticParameterException(e.toString(), e);
        }
    }

    @Override
    public DerivedCRS createDerivedCRS(Map<String, ?> properties, SingleCRS baseCRS, OperationMethod method, MathTransform baseToDerived, CoordinateSystem derivedCS) {
        return DefaultDerivedCRS.create(properties, baseCRS, null, method, baseToDerived, derivedCS);
    }

    @Override
    public AxisDirection directionAlongMeridian(AxisDirection baseDirection, double meridian) {
        return CoordinateSystems.directionAlongMeridian(baseDirection, meridian);
    }

    @Override
    public Object createToWGS84(double[] values) {
        BursaWolfParameters info = new BursaWolfParameters(CommonCRS.WGS84.datum(), null);
        info.setValues(values);
        return info;
    }

    @Override
    public SingleOperation createSingleOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, CoordinateOperationFactory factory) throws FactoryException {
        DefaultCoordinateOperationFactory df = factory instanceof DefaultCoordinateOperationFactory ? (DefaultCoordinateOperationFactory)factory : CoordinateOperations.factory();
        return df.createSingleOperation(properties, sourceCRS, targetCRS, interpolationCRS, method, null);
    }

    @Override
    public CoordinateOperationFactory getCoordinateOperationFactory(Map<String, ?> properties, MathTransformFactory mtFactory, CRSFactory crsFactory, CSFactory csFactory) {
        if (Containers.isNullOrEmpty(properties)) {
            if (DefaultFactories.isDefaultInstance(MathTransformFactory.class, mtFactory) && DefaultFactories.isDefaultInstance(CRSFactory.class, crsFactory) && DefaultFactories.isDefaultInstance(CSFactory.class, csFactory)) {
                return CoordinateOperations.factory();
            }
            properties = Collections.emptyMap();
        }
        HashMap p = new HashMap(properties);
        JDK8.putIfAbsent(p, "crsFactory", crsFactory);
        JDK8.putIfAbsent(p, "csFactory", csFactory);
        properties = p;
        return new DefaultCoordinateOperationFactory(properties, mtFactory);
    }

    @Override
    public Map<String, ?> getProperties(IdentifiedObject object) {
        return IdentifiedObjects.getProperties(object, new String[0]);
    }

    @Override
    public boolean isHeuristicMatchForName(IdentifiedObject object, String name) {
        return IdentifiedObjects.isHeuristicMatchForName(object, name);
    }

    @Override
    public OperationMethod getOperationMethod(CoordinateOperationFactory opFactory, MathTransformFactory mtFactory, String identifier) throws FactoryException {
        if (opFactory instanceof DefaultCoordinateOperationFactory) {
            ((DefaultCoordinateOperationFactory)opFactory).getOperationMethod(identifier);
        }
        return super.getOperationMethod(opFactory, mtFactory, identifier);
    }

    @Override
    public String getInformation(String key, Locale locale) {
        if (key.equals("EPSG")) {
            Citation authority;
            try {
                authority = CRS.getAuthorityFactory("EPSG").getAuthority();
            }
            catch (FactoryException e) {
                String msg = Exceptions.getLocalizedMessage(e, locale);
                return msg != null ? msg : e.toString();
            }
            if (authority instanceof DefaultCitation) {
                OnLineFunction f = OnLineFunction.valueOf(CONNECTION);
                for (OnlineResource res : ((DefaultCitation)authority).getOnlineResources()) {
                    InternationalString i18n;
                    if (!f.equals(res.getFunction()) || (i18n = res.getDescription()) == null) continue;
                    return i18n.toString(locale);
                }
                InternationalString i18n = authority.getTitle();
                if (i18n != null) {
                    return i18n.toString(locale);
                }
            }
            return Vocabulary.getResources(locale).getString((short)58);
        }
        return super.getInformation(key, locale);
    }
}

