/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;

public final class WKTUtilities
extends Static {
    private WKTUtilities() {
    }

    public static FormattableObject toFormattable(CoordinateReferenceSystem object) {
        if (object instanceof FormattableObject) {
            return (FormattableObject)((Object)object);
        }
        return AbstractCRS.castOrCopy(object);
    }

    public static FormattableObject toFormattable(CoordinateSystem object) {
        if (object instanceof FormattableObject) {
            return (FormattableObject)((Object)object);
        }
        return AbstractCS.castOrCopy(object);
    }

    public static FormattableObject toFormattable(CoordinateSystemAxis object) {
        if (object instanceof FormattableObject) {
            return (FormattableObject)((Object)object);
        }
        return DefaultCoordinateSystemAxis.castOrCopy(object);
    }

    public static FormattableObject toFormattable(Datum object) {
        if (object instanceof FormattableObject) {
            return (FormattableObject)((Object)object);
        }
        return AbstractDatum.castOrCopy(object);
    }

    public static FormattableObject toFormattable(GeodeticDatum object) {
        if (object instanceof FormattableObject) {
            return (FormattableObject)((Object)object);
        }
        return DefaultGeodeticDatum.castOrCopy(object);
    }

    public static FormattableObject toFormattable(Ellipsoid object) {
        if (object instanceof FormattableObject) {
            return (FormattableObject)((Object)object);
        }
        return DefaultEllipsoid.castOrCopy(object);
    }

    public static FormattableObject toFormattable(PrimeMeridian object) {
        if (object instanceof FormattableObject) {
            return (FormattableObject)((Object)object);
        }
        return DefaultPrimeMeridian.castOrCopy(object);
    }

    public static void appendName(IdentifiedObject object, Formatter formatter, ElementKind type) {
        String name = IdentifiedObjects.getName(object, formatter.getNameAuthority());
        if (name == null && (name = IdentifiedObjects.getName(object, null)) == null) {
            name = Vocabulary.getResources(formatter.getLocale()).getString((short)65);
        }
        formatter.append(name, type != null ? type : ElementKind.NAME);
    }

    public static void appendParamMT(ParameterValueGroup parameters, Formatter formatter) {
        if (parameters != null) {
            WKTUtilities.appendName(parameters.getDescriptor(), formatter, ElementKind.PARAMETER);
            WKTUtilities.append(parameters, formatter);
        }
    }

    public static void append(GeneralParameterValue parameter, Formatter formatter) {
        if (parameter instanceof ParameterValueGroup) {
            boolean first = true;
            for (GeneralParameterValue param : ((ParameterValueGroup)((Object)parameter)).values()) {
                if (first) {
                    formatter.newLine();
                    first = false;
                }
                WKTUtilities.append(param, formatter);
            }
        }
        if (parameter instanceof ParameterValue) {
            if (!(parameter instanceof FormattableObject)) {
                parameter = new DefaultParameterValue(parameter);
            }
            formatter.append(parameter);
            formatter.newLine();
        }
    }

    public static String toType(Class<?> base, Class<?> type) {
        int end;
        StringBuilder name;
        if (type != base && (name = ReferencingUtilities.toPropertyName(base, type)) != null && CharSequences.regionMatches(name, end = name.length() - 2, "CS")) {
            name.setLength(end);
            if ("time".contentEquals(name)) {
                return "temporal";
            }
            if (CharSequences.regionMatches(name, 0, "cartesian")) {
                name.setCharAt(0, 'C');
            }
            return name.toString();
        }
        return null;
    }
}

