/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

final class AffineMatrix
implements ExtendedPrecisionMatrix,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1605578645060388327L;
    private static final int SIZE = 3;
    private static final int LENGTH = 9;
    private static final int LENGTH_STORED = 6;
    private static final int LENGTH_EXTENDED = 18;
    private final AffineTransform transform;
    private final double[] errors;

    AffineMatrix(AffineTransform transform, double[] elements) {
        this.transform = transform;
        if (elements != null) {
            assert (elements.length == 9 || elements.length == 18);
            if (elements.length == 18) {
                this.errors = Arrays.copyOfRange(elements, 9, 15);
                return;
            }
        }
        this.errors = null;
    }

    @Override
    public int getNumRow() {
        return 3;
    }

    @Override
    public int getNumCol() {
        return 3;
    }

    @Override
    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    @Override
    public double[] getExtendedElements() {
        double[] elements = new double[this.errors != null ? 18 : 9];
        if (this.errors != null) {
            System.arraycopy(this.errors, 0, elements, 9, 6);
        }
        elements[0] = this.transform.getScaleX();
        elements[1] = this.transform.getShearX();
        elements[2] = this.transform.getTranslateX();
        elements[3] = this.transform.getShearY();
        elements[4] = this.transform.getScaleY();
        elements[5] = this.transform.getTranslateY();
        elements[8] = 1.0;
        return elements;
    }

    @Override
    public final double getElement(int row, int column) {
        ArgumentChecks.ensureBetween("row", 0, 3, row);
        ArgumentChecks.ensureBetween("column", 0, 3, column);
        switch (row * 3 + column) {
            case 0: {
                return this.transform.getScaleX();
            }
            case 1: {
                return this.transform.getShearX();
            }
            case 2: {
                return this.transform.getTranslateX();
            }
            case 3: {
                return this.transform.getShearY();
            }
            case 4: {
                return this.transform.getScaleY();
            }
            case 5: {
                return this.transform.getTranslateY();
            }
            case 6: 
            case 7: {
                return 0.0;
            }
            case 8: {
                return 1.0;
            }
        }
        throw new AssertionError();
    }

    @Override
    public final void setElement(int row, int column, double value) {
        throw new UnsupportedOperationException(Errors.format((short)119));
    }

    @Override
    public final Matrix clone() {
        return Matrices.copy(this);
    }

    public String toString() {
        return Matrices.toString(this);
    }
}

