/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.EPSGName;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

@XmlTransient
public final class Affine
extends AbstractProvider {
    private static final long serialVersionUID = 649555815622129472L;
    public static final String NAME = "Affine parametric transformation";
    private static volatile Affine EPSG_METHOD;
    public static final int EPSG_DIMENSION = 2;
    private static final int MAX_CACHED_DIMENSION = 6;
    private static final Affine[] cached;
    private static final Map<String, ?> IDENTIFICATION_EPSG;
    private static final Map<String, ?> IDENTIFICATION_OGC;

    public Affine() {
        super(IDENTIFICATION_EPSG, 2, 2, (ParameterDescriptorGroup)new Descriptor(IDENTIFICATION_EPSG, Arrays.copyOfRange(TensorParameters.ALPHANUM.getAllDescriptors(2, 3), 2, 8)));
        EPSG_METHOD = this;
    }

    private Affine(int sourceDimensions, int targetDimensions) {
        super(IDENTIFICATION_OGC, sourceDimensions, targetDimensions, (ParameterDescriptorGroup)new Descriptor(IDENTIFICATION_OGC, TensorParameters.WKT1.getAllDescriptors(targetDimensions + 1, sourceDimensions + 1)));
    }

    @Override
    public final boolean isInvertible() {
        return true;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException {
        return MathTransforms.linear(TensorParameters.WKT1.toMatrix(values));
    }

    @Override
    public OperationMethod redimension(int sourceDimensions, int targetDimensions) {
        return Affine.getProvider(sourceDimensions, targetDimensions, false);
    }

    private static int cacheIndex(int sourceDimensions, int targetDimensions) {
        if (--sourceDimensions >= 0 && sourceDimensions < 6 && --targetDimensions >= 0 && targetDimensions < 6) {
            return sourceDimensions * 6 + targetDimensions;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Affine getProvider(int sourceDimensions, int targetDimensions, boolean isAffine) {
        Affine[] affineArray;
        Affine method;
        if (isAffine && sourceDimensions == 2 && targetDimensions == 2) {
            method = EPSG_METHOD;
            if (method != null) return method;
            return new Affine();
        }
        int index = Affine.cacheIndex(sourceDimensions, targetDimensions);
        if (index >= 0) {
            affineArray = cached;
            // MONITORENTER : cached
            method = cached[index];
            // MONITOREXIT : affineArray
            if (method != null) {
                return method;
            }
        }
        method = new Affine(sourceDimensions, targetDimensions);
        if (index < 0) return method;
        affineArray = cached;
        // MONITORENTER : cached
        Affine other = cached[index];
        if (other != null) {
            // MONITOREXIT : affineArray
            return other;
        }
        Affine.cached[index] = method;
        // MONITOREXIT : affineArray
        return method;
    }

    public static ParameterValueGroup parameters(Matrix matrix) {
        Map<String, ?> properties;
        TensorParameters<Double> parameters;
        int sourceDimensions = matrix.getNumCol() - 1;
        int targetDimensions = matrix.getNumRow() - 1;
        if (sourceDimensions == 2 && targetDimensions == 2 && Matrices.isAffine(matrix)) {
            parameters = TensorParameters.ALPHANUM;
            properties = IDENTIFICATION_EPSG;
        } else {
            parameters = TensorParameters.WKT1;
            properties = IDENTIFICATION_OGC;
        }
        return parameters.createValueGroup(properties, matrix);
    }

    static {
        cached = new Affine[36];
        NamedIdentifier nameOGC = new NamedIdentifier(Citations.OGC, "OGC", (CharSequence)"Affine", null, null);
        IDENTIFICATION_OGC = Collections.singletonMap("name", nameOGC);
        IDENTIFICATION_EPSG = EPSGName.properties(9624, NAME, nameOGC);
    }

    private static final class Descriptor
    extends DefaultParameterDescriptorGroup {
        private static final long serialVersionUID = 8320799650519834830L;

        Descriptor(Map<String, ?> properties, ParameterDescriptor<?>[] parameters) {
            super(properties, 1, 1, parameters);
        }

        @Override
        public ParameterValueGroup createValue() {
            return TensorParameters.WKT1.createValueGroup(IDENTIFICATION_OGC);
        }
    }
}

