/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Arrays;
import javax.measure.quantity.Quantity;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.math.DecimalFunctions;

final class DatumShiftGridCompressed<C extends Quantity, T extends Quantity>
extends DatumShiftGridFile<C, T> {
    private static final long serialVersionUID = 4847888093457104917L;
    private final int ymax = this.getGridSize()[1] - 2;
    private final double[] averages;
    private final short[][] data;
    private final double scale;

    private DatumShiftGridCompressed(DatumShiftGridFile<C, T> grid, double[] averages, short[][] data, double scale) {
        super(grid);
        this.averages = averages;
        this.data = data;
        this.scale = scale;
    }

    static <C extends Quantity, T extends Quantity> DatumShiftGridFile<C, T> compress(DatumShiftGridFile.Float<C, T> grid, double[] averages, double scale) {
        boolean computeAverages;
        short[][] data = new short[grid.offsets.length][];
        boolean bl = computeAverages = averages == null;
        if (computeAverages) {
            averages = new double[data.length];
        }
        for (int dim = 0; dim < data.length; ++dim) {
            double average;
            if (computeAverages) {
                average = Math.rint(grid.getCellMean(dim) / scale);
                averages[dim] = average * scale;
            } else {
                average = averages[dim] / scale;
            }
            float[] offsets = grid.offsets[dim];
            short[] compressed = new short[offsets.length];
            for (int i = 0; i < offsets.length; ++i) {
                double c = DecimalFunctions.floatToDouble(offsets[i]);
                float tolerance = Math.ulp((float)(c /= scale));
                c -= average;
                if (Math.abs(c -= (double)(compressed[i] = (short)Math.round(c))) < (double)tolerance) continue;
                return grid;
            }
            data[dim] = compressed;
        }
        return new DatumShiftGridCompressed<C, T>(grid, averages, data, scale);
    }

    @Override
    final DatumShiftGridFile<C, T> setData(Object[] other) {
        return new DatumShiftGridCompressed<C, T>(this, this.averages, (short[][])other, this.scale);
    }

    @Override
    public double getCellPrecision() {
        return Math.min(super.getCellPrecision(), 5.0 * this.scale);
    }

    @Override
    final Object[] getData() {
        return this.data;
    }

    @Override
    public final int getTranslationDimensions() {
        return this.data.length;
    }

    @Override
    public double getCellMean(int dim) {
        return this.averages[dim];
    }

    @Override
    public double getCellValue(int dim, int gridX, int gridY) {
        return (double)this.data[dim][gridX + gridY * this.nx] * this.scale + this.averages[dim];
    }

    @Override
    public void interpolateInCell(double gridX, double gridY, double[] vector) {
        int ix = (int)gridX;
        gridX -= (double)ix;
        int iy = (int)gridY;
        gridY -= (double)iy;
        if (ix < 0) {
            ix = 0;
            gridX = -1.0;
        } else if (ix >= this.nx - 1) {
            ix = this.nx - 2;
            gridX = 1.0;
        }
        if (iy < 0) {
            iy = 0;
            gridY = -1.0;
        } else if (iy > this.ymax) {
            iy = this.ymax;
            gridY = 1.0;
        }
        int p0 = this.nx * iy + ix;
        int p1 = this.nx + p0;
        for (int dim = 0; dim < this.data.length; ++dim) {
            short[] values = this.data[dim];
            double r0 = values[p0];
            double r1 = values[p1];
            r0 += gridX * ((double)values[p0 + 1] - r0);
            r1 += gridX * ((double)values[p1 + 1] - r1);
            vector[dim] = (gridY * (r1 - r0) + r0) * this.scale + this.averages[dim];
        }
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            DatumShiftGridCompressed that = (DatumShiftGridCompressed)other;
            return Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(that.scale) && Arrays.equals(this.averages, that.averages);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.averages);
    }
}

