/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Path;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.util.collection.Cache;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public abstract class DatumShiftGridFile<C extends Quantity, T extends Quantity>
extends DatumShiftGrid<C, T> {
    private static final long serialVersionUID = -4471670781277328193L;
    static final Cache<Object, DatumShiftGridFile<?, ?>> CACHE = new Cache<Object, DatumShiftGridFile<?, ?>>(4, 32768L, true){

        @Override
        protected int cost(DatumShiftGridFile<?, ?> grid) {
            int p = 1;
            for (Object array : grid.getData()) {
                p *= Array.getLength(array);
            }
            return p;
        }
    };
    public final ParameterDescriptorGroup descriptor;
    private final Path[] files;
    final int nx;
    double accuracy;

    DatumShiftGridFile(Unit<C> coordinateUnit, Unit<T> translationUnit, boolean isCellValueRatio, double x0, double y0, double \u0394x, double \u0394y, int nx, int ny, ParameterDescriptorGroup descriptor, Path ... files) throws NoninvertibleTransformException {
        super(coordinateUnit, new AffineTransform2D(\u0394x, 0.0, 0.0, \u0394y, x0, y0).inverse(), new int[]{nx, ny}, isCellValueRatio, translationUnit);
        this.descriptor = descriptor;
        this.files = files;
        this.nx = nx;
        this.accuracy = Double.NaN;
        if (files.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    DatumShiftGridFile(DatumShiftGridFile<C, T> other) {
        super(other);
        this.descriptor = other.descriptor;
        this.files = other.files;
        this.nx = other.nx;
        this.accuracy = other.accuracy;
    }

    @Override
    public double getCellPrecision() {
        return this.accuracy / 10.0;
    }

    final DatumShiftGridFile<C, T> useSharedData() {
        Object[] data = this.getData();
        for (DatumShiftGridFile grid : CACHE.values()) {
            Object[] other = grid.getData();
            if (!Arrays.deepEquals(data, other)) continue;
            return this.setData(other);
        }
        return this;
    }

    abstract DatumShiftGridFile<C, T> setData(Object[] var1);

    abstract Object[] getData();

    public final void setFileParameters(Parameters parameters) {
        int i = 0;
        for (GeneralParameterDescriptor gd : this.descriptor.descriptors()) {
            ParameterDescriptor d;
            if (!(gd instanceof ParameterDescriptor) || !File.class.isAssignableFrom((d = (ParameterDescriptor)gd).getValueClass())) continue;
            parameters.getOrCreate(d).setValue(this.files[i]);
            if (++i != this.files.length) continue;
            break;
        }
    }

    final <NC extends Quantity, NT extends Quantity> DatumShiftGridFile<NC, NT> castTo(Class<NC> coordinateType, Class<NT> translationType) {
        super.getCoordinateUnit().asType(coordinateType);
        super.getTranslationUnit().asType(translationType);
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (super.equals(other)) {
            DatumShiftGridFile that = (DatumShiftGridFile)other;
            return Arrays.equals(this.files, that.files) && Arrays.deepEquals(this.getData(), that.getData());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.files);
    }

    public String toString() {
        return "DatumShiftGrid[\"" + this.files[0].getFileName() + "\"]";
    }

    static final class Float<C extends Quantity, T extends Quantity>
    extends DatumShiftGridFile<C, T> {
        private static final long serialVersionUID = -9221609983475286496L;
        final float[][] offsets;

        Float(int dim, Unit<C> coordinateUnit, Unit<T> translationUnit, boolean isCellValueRatio, double x0, double y0, double \u0394x, double \u0394y, int nx, int ny, ParameterDescriptorGroup descriptor, Path ... files) throws NoninvertibleTransformException {
            super(coordinateUnit, translationUnit, isCellValueRatio, x0, y0, \u0394x, \u0394y, nx, ny, descriptor, files);
            this.offsets = new float[dim][];
            int size = JDK8.multiplyExact(nx, ny);
            for (int i = 0; i < dim; ++i) {
                this.offsets[i] = new float[size];
                Arrays.fill(this.offsets[i], java.lang.Float.NaN);
            }
        }

        private Float(DatumShiftGridFile<C, T> grid, float[][] offsets) {
            super(grid);
            this.offsets = offsets;
        }

        @Override
        final DatumShiftGridFile<C, T> setData(Object[] other) {
            return new Float<C, T>(this, (float[][])other);
        }

        @Override
        final Object[] getData() {
            return this.offsets;
        }

        @Override
        public final int getTranslationDimensions() {
            return this.offsets.length;
        }

        @Override
        public final double getCellValue(int dim, int gridX, int gridY) {
            return DecimalFunctions.floatToDouble(this.offsets[dim][gridX + gridY * this.nx]);
        }
    }
}

