/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.List;
import javax.measure.unit.NonSI;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.referencing.provider.GeocentricTranslation;
import org.apache.sis.internal.referencing.provider.GeocentricTranslation2D;
import org.apache.sis.internal.referencing.provider.GeocentricTranslation3D;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.internal.referencing.provider.PositionVector7Param;
import org.apache.sis.internal.referencing.provider.PositionVector7Param2D;
import org.apache.sis.internal.referencing.provider.PositionVector7Param3D;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

@XmlTransient
public abstract class GeocentricAffine
extends GeodeticOperation {
    private static final long serialVersionUID = 8291967302538661639L;
    private static final double BURSAWOLF_TOLERANCE = 1.0E-6;
    public static final ParameterDescriptor<Double> TX;
    public static final ParameterDescriptor<Double> TY;
    public static final ParameterDescriptor<Double> TZ;
    static final ParameterDescriptor<Double> RX;
    static final ParameterDescriptor<Double> RY;
    static final ParameterDescriptor<Double> RZ;
    static final ParameterDescriptor<Double> DS;
    static final int TRANSLATION = 1;
    static final int SEVEN_PARAM = 2;
    static final int FRAME_ROTATION = 3;
    static final int OTHER = 0;

    private static ParameterDescriptor<Double> createRotation(ParameterBuilder builder, String name, String alias) {
        return ((ParameterBuilder)((ParameterBuilder)builder.addName(name)).addName(Citations.OGC, alias)).createBounded(-648000.0, 648000.0, 0.0, NonSI.SECOND_ANGLE);
    }

    GeocentricAffine(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters, GeodeticOperation[] redimensioned) {
        super(sourceDimensions, targetDimensions, parameters, redimensioned);
    }

    abstract int getType();

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        BursaWolfParameters parameters = new BursaWolfParameters(null, null);
        Parameters pv = Parameters.castOrWrap(values);
        boolean reverseRotation = false;
        switch (this.getType()) {
            default: {
                throw new AssertionError();
            }
            case 3: {
                reverseRotation = true;
            }
            case 2: {
                parameters.rX = pv.doubleValue(RX);
                parameters.rY = pv.doubleValue(RY);
                parameters.rZ = pv.doubleValue(RZ);
                parameters.dS = pv.doubleValue(DS);
            }
            case 1: 
        }
        parameters.tX = pv.doubleValue(TX);
        parameters.tY = pv.doubleValue(TY);
        parameters.tZ = pv.doubleValue(TZ);
        if (reverseRotation) {
            parameters.reverseRotation();
        }
        return MathTransforms.linear(parameters.getPositionVectorTransformation(null));
    }

    private static Parameters createParameters(ParameterDescriptorGroup descriptor, BursaWolfParameters parameters, boolean isTranslation) {
        Parameters values = Parameters.castOrWrap(descriptor.createValue());
        values.getOrCreate(TX).setValue(parameters.tX);
        values.getOrCreate(TY).setValue(parameters.tY);
        values.getOrCreate(TZ).setValue(parameters.tZ);
        if (!isTranslation) {
            values.getOrCreate(RX).setValue(parameters.rX);
            values.getOrCreate(RY).setValue(parameters.rY);
            values.getOrCreate(RZ).setValue(parameters.rZ);
            values.getOrCreate(DS).setValue(parameters.dS);
        }
        return values;
    }

    public static ParameterValueGroup createParameters(CoordinateSystem sourceCS, CoordinateSystem targetCS, Matrix datumShift, boolean useMolodensky) {
        ParameterDescriptorGroup descriptor;
        boolean isEllipsoidal = sourceCS instanceof EllipsoidalCS;
        if (!(!isEllipsoidal ? targetCS instanceof CartesianCS && sourceCS instanceof CartesianCS : targetCS instanceof EllipsoidalCS)) {
            return null;
        }
        int dimension = sourceCS.getDimension();
        if (dimension != targetCS.getDimension()) {
            dimension = 4;
        }
        BursaWolfParameters parameters = new BursaWolfParameters(null, null);
        try {
            parameters.setPositionVectorTransformation(datumShift, 1.0E-6);
        }
        catch (IllegalArgumentException e) {
            GeocentricAffine.log("org.apache.sis.referencing.operation", "createParameters", e);
            return null;
        }
        boolean isTranslation = parameters.isTranslation();
        if (!isEllipsoidal) {
            useMolodensky = false;
            descriptor = isTranslation ? GeocentricTranslation.PARAMETERS : PositionVector7Param.PARAMETERS;
        } else if (!isTranslation) {
            useMolodensky = false;
            descriptor = dimension >= 3 ? PositionVector7Param3D.PARAMETERS : PositionVector7Param2D.PARAMETERS;
        } else {
            descriptor = !useMolodensky ? (dimension >= 3 ? GeocentricTranslation3D.PARAMETERS : GeocentricTranslation2D.PARAMETERS) : Molodensky.PARAMETERS;
        }
        Parameters values = GeocentricAffine.createParameters(descriptor, parameters, isTranslation);
        if (useMolodensky && dimension <= 3) {
            values.getOrCreate(Molodensky.DIMENSION).setValue(dimension);
        }
        return values;
    }

    public static void asDatumShift(List<Object> transforms) {
        int i = transforms.size() - 2;
        while (--i >= 0) {
            Object step;
            if (!GeocentricAffine.isOperation("Ellipsoid_To_Geocentric", transforms.get(i)) || !GeocentricAffine.isOperation("Geocentric_To_Ellipsoid", transforms.get(i + 2)) || !((step = transforms.get(i + 1)) instanceof LinearTransform)) continue;
            BursaWolfParameters parameters = new BursaWolfParameters(null, null);
            try {
                parameters.setPositionVectorTransformation(((LinearTransform)step).getMatrix(), 1.0E-6);
            }
            catch (IllegalArgumentException e) {
                GeocentricAffine.log("org.apache.sis.io.wkt", "asDatumShift", e);
                continue;
            }
            boolean isTranslation = parameters.isTranslation();
            final Parameters values = GeocentricAffine.createParameters(isTranslation ? GeocentricTranslation.PARAMETERS : PositionVector7Param.PARAMETERS, parameters, isTranslation);
            transforms.set(i + 1, new FormattableObject(){

                @Override
                protected String formatTo(Formatter formatter) {
                    WKTUtilities.appendParamMT(values, formatter);
                    return "Param_MT";
                }
            });
        }
    }

    private static boolean isOperation(String expected, Object actual) {
        return actual instanceof Parameterized && IdentifiedObjects.isHeuristicMatchForName(((Parameterized)actual).getParameterDescriptors(), expected);
    }

    private static void log(String logger, String method, Exception e) {
        Logging.recoverableException(Logging.getLogger(logger), GeocentricAffine.class, method, e);
    }

    static {
        ParameterBuilder builder = GeocentricAffine.builder();
        TX = GeocentricAffine.createShift((ParameterBuilder)((ParameterBuilder)builder.addName("X-axis translation")).addName(Citations.OGC, "dx"));
        TY = GeocentricAffine.createShift((ParameterBuilder)((ParameterBuilder)builder.addName("Y-axis translation")).addName(Citations.OGC, "dy"));
        TZ = GeocentricAffine.createShift((ParameterBuilder)((ParameterBuilder)builder.addName("Z-axis translation")).addName(Citations.OGC, "dz"));
        RX = GeocentricAffine.createRotation(builder, "X-axis rotation", "ex");
        RY = GeocentricAffine.createRotation(builder, "Y-axis rotation", "ey");
        RZ = GeocentricAffine.createRotation(builder, "Z-axis rotation", "ez");
        DS = ((ParameterBuilder)((ParameterBuilder)builder.addName("Scale difference")).addName(Citations.OGC, "ppm")).create(1.0, Units.PPM);
    }
}

