/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.GeographicToGeocentric;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public final class GeocentricToGeographic
extends AbstractProvider {
    private static final long serialVersionUID = 8459294628751497567L;
    static final String NAME = "Geocentric_To_Ellipsoid";
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)GeocentricToGeographic.builder().addName(Citations.OGC, "Geocentric_To_Ellipsoid")).createGroupForMapProjection(new ParameterDescriptor[0]);

    public GeocentricToGeographic() {
        super(3, 3, PARAMETERS);
    }

    public Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    public int getEllipsoidsMask() {
        return 2;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        MathTransform tr = GeographicToGeocentric.create(factory, values);
        try {
            tr = tr.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new FactoryException(e);
        }
        return tr;
    }
}

