/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Geographic2Dto3D
extends AbstractProvider {
    private static final long serialVersionUID = -1198461394243672064L;
    public static final ParameterDescriptor<Double> HEIGHT;
    public static final ParameterDescriptorGroup PARAMETERS;

    public Geographic2Dto3D() {
        super(2, 3, PARAMETERS);
    }

    public Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        Parameters pv = Parameters.castOrWrap(values);
        MatrixSIS m = Matrices.createDiagonal(4, 3);
        m.setElement(2, 2, pv.doubleValue(HEIGHT));
        m.setElement(3, 2, 1.0);
        return factory.createAffineTransform(m);
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)Geographic2Dto3D.builder().setCodeSpace(Citations.SIS, "SIS");
        HEIGHT = Geographic2Dto3D.createShift((ParameterBuilder)builder.addName("height"));
        PARAMETERS = ((ParameterBuilder)builder.addName("Geographic2D to 3D conversion")).createGroup(HEIGHT);
    }
}

