/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.GeographicOffsets2D;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;

@XmlTransient
public class GeographicOffsets
extends GeodeticOperation {
    private static final long serialVersionUID = -6246011184175753328L;
    static final ParameterDescriptor<Double> TX;
    static final ParameterDescriptor<Double> TY;
    static final ParameterDescriptor<Double> TZ;
    private static final ParameterDescriptorGroup PARAMETERS;

    public GeographicOffsets() {
        super(3, 3, PARAMETERS, new GeographicOffsets[4]);
        this.redimensioned[0] = new GeographicOffsets2D(this.redimensioned);
        this.redimensioned[1] = new GeographicOffsets(2, 3, PARAMETERS, this.redimensioned);
        this.redimensioned[2] = new GeographicOffsets(3, 2, PARAMETERS, this.redimensioned);
        this.redimensioned[3] = this;
    }

    GeographicOffsets(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters, GeodeticOperation[] redimensioned) {
        super(sourceDimensions, targetDimensions, parameters, redimensioned);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException {
        Parameters pv = Parameters.castOrWrap(values);
        Matrix4 t = new Matrix4();
        t.m03 = pv.doubleValue(TX);
        t.m13 = pv.doubleValue(TY);
        t.m23 = pv.doubleValue(TZ);
        return MathTransforms.linear(t);
    }

    static {
        ParameterBuilder builder = GeographicOffsets.builder();
        TY = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8601")).addName("Latitude offset")).create(0.0, NonSI.DEGREE_ANGLE);
        TX = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8602")).addName("Longitude offset")).create(0.0, NonSI.DEGREE_ANGLE);
        TZ = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8603")).addName("Vertical Offset")).create(0.0, SI.METRE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9660")).addName("Geographic3D offsets")).createGroup(TY, TX, TZ);
    }
}

