/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

public final class GeographicToGeocentric
extends AbstractProvider {
    private static final long serialVersionUID = -5690807111952562344L;
    static final String NAME = "Ellipsoid_To_Geocentric";
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)GeographicToGeocentric.builder().addIdentifier("9602")).addName("Geographic/geocentric conversions")).addName(Citations.OGC, "Ellipsoid_To_Geocentric")).createGroupForMapProjection(new ParameterDescriptor[0]);

    public GeographicToGeocentric() {
        super(3, 3, PARAMETERS);
    }

    public Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    public int getEllipsoidsMask() {
        return 1;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        return GeographicToGeocentric.create(factory, values);
    }

    static MathTransform create(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        ParameterValue<?> semiMajor = values.parameter("semi_major");
        Unit<Length> unit = semiMajor.getUnit().asType(Length.class);
        return EllipsoidToCentricTransform.createGeodeticConversion(factory, semiMajor.doubleValue(), values.parameter("semi_minor").doubleValue(unit), unit, true, EllipsoidToCentricTransform.TargetType.CARTESIAN);
    }
}

