/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.measure.unit.SI;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@XmlTransient
public abstract class MapProjection
extends AbstractProvider {
    private static final long serialVersionUID = 6280666068007678702L;
    public static final DefaultParameterDescriptor<Double> SEMI_MAJOR;
    public static final DefaultParameterDescriptor<Double> SEMI_MINOR;
    public static final DefaultParameterDescriptor<Double> ECCENTRICITY;

    protected MapProjection(ParameterDescriptorGroup parameters) {
        super(2, 2, parameters);
    }

    public Class<? extends Projection> getOperationType() {
        return Projection.class;
    }

    public static void validate(ParameterDescriptor<? extends Number> descriptor, double value) throws IllegalArgumentException {
        double maxValue;
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException(Errors.format((short)144, descriptor.getName(), value));
        }
        Comparable<? extends Number> min = descriptor.getMinimumValue();
        Comparable<? extends Number> max = descriptor.getMaximumValue();
        double minValue = min instanceof Number ? ((Number)((Object)min)).doubleValue() : Double.NaN;
        double d = maxValue = max instanceof Number ? ((Number)((Object)max)).doubleValue() : Double.NaN;
        if ((value < minValue || value > maxValue) && minValue != maxValue) {
            throw new IllegalArgumentException(Errors.format((short)133, descriptor.getName(), min, max, value));
        }
    }

    @Override
    public final MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
        return this.createProjection(Parameters.castOrWrap(parameters)).createMapProjection(factory);
    }

    protected abstract NormalizedProjection createProjection(Parameters var1) throws ParameterNotFoundException;

    @Override
    public final int getEllipsoidsMask() {
        return 1;
    }

    static GenericName sameNameAs(Citation authority, GeneralParameterDescriptor parameters) {
        for (GenericName candidate : parameters.getAlias()) {
            if (!(candidate instanceof Identifier) || ((Identifier)((Object)candidate)).getAuthority() != authority) continue;
            return candidate;
        }
        throw new NoSuchElementException();
    }

    static ParameterBuilder except(ParameterDescriptor<Double> source, Citation except, GenericName replacement, ParameterBuilder builder) {
        for (GenericName alias : source.getAlias()) {
            if (((Identifier)((Object)alias)).getAuthority() == except) {
                if (replacement == null) continue;
                alias = replacement;
                replacement = null;
            }
            builder.addName(alias);
        }
        for (ReferenceIdentifier id : source.getIdentifiers()) {
            builder.addIdentifier(id);
        }
        return builder;
    }

    static ParameterBuilder exceptEPSG(ParameterDescriptor<?> source, ParameterBuilder builder) {
        for (GenericName alias : source.getAlias()) {
            builder.addName(alias);
        }
        return builder;
    }

    static InternationalString notFormalParameter(String origin) {
        return Messages.formatInternational((short)10, (Object)origin);
    }

    static {
        MeasurementRange<Double> valueDomain = MeasurementRange.createGreaterThan(0.0, SI.METRE);
        GenericName[] aliases = new GenericName[]{new NamedIdentifier(Citations.ESRI, "Semi_Major"), new NamedIdentifier(Citations.NETCDF, "semi_major_axis"), new NamedIdentifier(Citations.GEOTIFF, "SemiMajor"), new NamedIdentifier(Citations.PROJ4, "a")};
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("authority", Citations.OGC);
        properties.put("name", "semi_major");
        properties.put("alias", aliases);
        SEMI_MAJOR = new DefaultParameterDescriptor<Object>(properties, 1, 1, Double.class, valueDomain, null, null);
        properties.put("name", "semi_minor");
        aliases[0] = new NamedIdentifier(Citations.ESRI, "Semi_Minor");
        aliases[1] = new NamedIdentifier(Citations.NETCDF, "semi_minor_axis");
        aliases[2] = new NamedIdentifier(Citations.GEOTIFF, "SemiMinor");
        aliases[3] = new NamedIdentifier(Citations.PROJ4, "b");
        SEMI_MINOR = new DefaultParameterDescriptor<Object>(properties, 1, 1, Double.class, valueDomain, null, null);
        properties.clear();
        properties.put("authority", Citations.SIS);
        properties.put("name", "eccentricity");
        ECCENTRICITY = new DefaultParameterDescriptor<Object>(properties, 1, 1, Double.class, MeasurementRange.create(0.0, true, 1.0, true, null), null, null);
    }
}

