/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractMercator;
import org.apache.sis.internal.referencing.provider.LambertConformal2SP;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

@XmlTransient
public final class TransverseMercator
extends AbstractMercator {
    private static final long serialVersionUID = -3386587506686432398L;
    private static final double ZONE_WIDTH = 6.0;
    public static final String NAME = "Transverse Mercator";
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    static final ParameterDescriptorGroup PARAMETERS;

    public TransverseMercator() {
        super(PARAMETERS);
    }

    @Override
    protected NormalizedProjection createProjection(Parameters parameters) {
        return new org.apache.sis.referencing.operation.projection.TransverseMercator(this, parameters);
    }

    public static String setParameters(ParameterValueGroup group, boolean isUTM, double latitude, double longitude) {
        boolean isSouth = MathFunctions.isNegative(latitude);
        int zone = TransverseMercator.zone(longitude);
        if (isUTM) {
            latitude = 0.0;
            longitude = TransverseMercator.centralMeridian(zone);
        } else if (longitude != TransverseMercator.centralMeridian(zone)) {
            zone = 0;
        }
        String name = NAME;
        if (zone != 0) {
            name = "UTM zone " + zone + (isSouth ? (char)'S' : 'N');
        }
        group.parameter("latitude_of_origin").setValue(latitude, NonSI.DEGREE_ANGLE);
        group.parameter("central_meridian").setValue(longitude, NonSI.DEGREE_ANGLE);
        group.parameter("scale_factor").setValue(0.9996, Unit.ONE);
        group.parameter("false_easting").setValue(500000.0, SI.METRE);
        group.parameter("false_northing").setValue(isSouth ? 1.0E7 : 0.0, SI.METRE);
        return name;
    }

    public static int zone(double longitude) {
        double z = (longitude - -180.0) / 6.0;
        z -= Math.floor(z / 60.0) * 60.0;
        return (int)(z + 1.0);
    }

    public static double centralMeridian(int zone) {
        return ((double)zone - 0.5) * 6.0 + -180.0;
    }

    static {
        ParameterBuilder builder = TransverseMercator.builder();
        LATITUDE_OF_ORIGIN = TransverseMercator.createLatitude((ParameterBuilder)builder.addNamesAndIdentifiers(Mercator1SP.LATITUDE_OF_ORIGIN), true);
        builder.addName(Mercator1SP.LONGITUDE_OF_ORIGIN.getName());
        LONGITUDE_OF_ORIGIN = TransverseMercator.createLongitude(TransverseMercator.except(Mercator1SP.LONGITUDE_OF_ORIGIN, Citations.NETCDF, TransverseMercator.sameNameAs(Citations.NETCDF, LambertConformal2SP.LONGITUDE_OF_FALSE_ORIGIN), builder));
        SCALE_FACTOR = TransverseMercator.createScale((ParameterBuilder)((ParameterBuilder)builder.addNamesAndIdentifiers(Mercator1SP.SCALE_FACTOR)).rename(Citations.NETCDF, "scale_factor_at_central_meridian"));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9807")).addName(NAME)).addName("Gauss-Kruger")).addName("Gauss-Boaga")).addName("TM")).addName(Citations.OGC, "Transverse_Mercator")).addName(Citations.ESRI, "Transverse_Mercator")).addName(Citations.ESRI, "Gauss_Kruger")).addName(Citations.NETCDF, "TransverseMercator")).addName(Citations.GEOTIFF, "CT_TransverseMercator")).addName(Citations.S57, NAME)).addName(Citations.S57, "TME")).addName(Citations.PROJ4, "tmerc")).addIdentifier(Citations.GEOTIFF, "1")).addIdentifier(Citations.MAP_INFO, "8")).addIdentifier(Citations.S57, "13")).createGroupForMapProjection(LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING);
    }
}

