/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.simple;

import java.io.Serializable;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Deprecable;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public class SimpleIdentifier
implements ReferenceIdentifier,
Deprecable,
Serializable {
    private static final long serialVersionUID = -3544709943777129514L;
    protected final Citation authority;
    protected final String code;
    protected final boolean isDeprecated;

    public SimpleIdentifier(Citation authority, String code, boolean isDeprecated) {
        this.authority = authority;
        this.code = code;
        this.isDeprecated = isDeprecated;
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public String getCodeSpace() {
        return Citations.getCodeSpace(this.authority);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getVersion() {
        InternationalString version;
        if (this.authority != null && (version = this.authority.getEdition()) != null) {
            return version.toString();
        }
        return null;
    }

    @Override
    public InternationalString getRemarks() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            SimpleIdentifier that = (SimpleIdentifier)obj;
            return Objects.equals(this.code, that.code) && Objects.equals(this.authority, that.authority) && this.isDeprecated == that.isDeprecated;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.code, this.isDeprecated) ^ 0x395E8BD6;
    }

    public String toString() {
        String classname = Classes.getShortClassName(this);
        StringBuilder buffer = new StringBuilder(classname.length() + CharSequences.length(this.code) + 10);
        buffer.append(classname).append('[');
        String codespace = this.getCodeSpace();
        boolean open = false;
        if (codespace != null) {
            buffer.append('\u201c').append(codespace);
            open = true;
        }
        if (this.code != null) {
            buffer.append(open ? (char)':' : '\u201c').append(this.code);
            open = true;
        }
        if (open) {
            buffer.append('\u201d');
        }
        this.appendToString(buffer);
        return buffer.append(']').toString();
    }

    protected void appendToString(StringBuilder buffer) {
    }

    public String toWKT() {
        StringBuilder buffer = new StringBuilder(40).append("Id[");
        SimpleIdentifier.append(buffer, Citations.getIdentifier(this.authority, true));
        SimpleIdentifier.append(buffer.append(", "), this.code);
        return buffer.append(']').toString();
    }

    private static void append(StringBuilder buffer, String value) {
        if (value == null) {
            buffer.append("null");
        } else {
            buffer.append('\"').append(value).append('\"');
        }
    }
}

