/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.sis.internal.jdk7.Files;
import org.apache.sis.internal.jdk7.StandardCharsets;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public final class IOUtilities
extends Static {
    private static final List<String> ILLEGAL_OPTIONS = Arrays.asList("APPEND", "TRUNCATE_EXISTING", "DELETE_ON_CLOSE");

    private IOUtilities() {
    }

    public static String filename(Object path) {
        return IOUtilities.part(path, false);
    }

    public static String extension(Object path) {
        return IOUtilities.part(path, true);
    }

    private static String part(Object path, boolean extension) {
        String name;
        int fromIndex = 0;
        if (path instanceof File) {
            name = ((File)path).getName();
        } else {
            int separator = 47;
            if (path instanceof URL) {
                name = ((URL)path).getPath();
            } else if (path instanceof URI) {
                URI uri = (URI)path;
                name = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
            } else if (path instanceof CharSequence) {
                name = path.toString();
                separator = File.separatorChar;
            } else {
                return null;
            }
            fromIndex = name.lastIndexOf(47) + 1;
            if (separator != 47) {
                fromIndex = Math.max(fromIndex, CharSequences.lastIndexOf(name, separator, fromIndex, name.length()) + 1);
            }
        }
        if (extension && (fromIndex = CharSequences.lastIndexOf(name, 46, fromIndex, name.length()) + 1) <= 1) {
            return "";
        }
        return name.substring(fromIndex);
    }

    public static String toString(Object path) {
        if (path instanceof CharSequence || path instanceof URL || path instanceof URI) {
            return path.toString();
        }
        if (path instanceof File) {
            return ((File)path).getPath();
        }
        return null;
    }

    public static String encodeURI(String path) {
        int n;
        if (path == null) {
            return null;
        }
        StringBuilder buffer = null;
        int length = path.length();
        for (int i = 0; i < length; i += n) {
            int c = path.codePointAt(i);
            n = Character.charCount(c);
            if (!Character.isSpaceChar(c) && !Character.isISOControl(c) && c != 37) {
                if (buffer == null) continue;
                buffer.appendCodePoint(c);
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuilder(path);
                buffer.setLength(i);
            }
            for (byte b : path.substring(i, i + n).getBytes(StandardCharsets.UTF_8)) {
                buffer.append('%');
                String hex = Integer.toHexString(b & 0xFF).toUpperCase(Locale.ROOT);
                if (hex.length() < 2) {
                    buffer.append('0');
                }
                buffer.append(hex);
            }
        }
        return buffer != null ? buffer.toString() : path;
    }

    public static URI toURI(URL url, String encoding) throws IOException {
        if (url == null) {
            return null;
        }
        String path = url.toExternalForm();
        if (encoding != null) {
            path = URLDecoder.decode(path, encoding);
        }
        path = IOUtilities.encodeURI(path);
        try {
            return new URI(path);
        }
        catch (URISyntaxException cause) {
            MalformedURLException e = new MalformedURLException(Exceptions.formatChainedMessages(null, Errors.format((short)31, "URL", path), cause));
            e.initCause(cause);
            throw e;
        }
    }

    public static File toFile(URL url, String encoding) throws IOException {
        if (url == null) {
            return null;
        }
        URI uri = IOUtilities.toURI(url, encoding);
        try {
            return new File(uri);
        }
        catch (IllegalArgumentException cause) {
            throw new IOException(Exceptions.formatChainedMessages(null, Errors.format((short)31, "URL", url), cause), cause);
        }
    }

    public static Object toFileOrURL(String path, String encoding) throws IOException {
        int s;
        if (path == null) {
            return null;
        }
        if (path.indexOf(63) < 0 && path.indexOf(35) < 0 && ((s = path.indexOf(58)) < 0 || s == 1 && Character.isLetter(path.charAt(0)) && !path.regionMatches(2, "//", 0, 2))) {
            return new File(path);
        }
        URL url = new URL(path);
        String scheme = url.getProtocol();
        if (scheme != null && scheme.equalsIgnoreCase("file")) {
            return IOUtilities.toFile(url, encoding);
        }
        return url;
    }

    public static ReadableByteChannel open(Object input, String encoding, Object ... options) throws IOException {
        Set optionSet;
        if (options == null || options.length == 0) {
            optionSet = Collections.emptySet();
        } else {
            optionSet = new HashSet<Object>(Arrays.asList(options));
            optionSet.add("READ");
            if (optionSet.removeAll(ILLEGAL_OPTIONS)) {
                throw new IllegalArgumentException(Errors.format((short)31, "options", Arrays.toString(options)));
            }
        }
        if (input instanceof ReadableByteChannel) {
            return (ReadableByteChannel)input;
        }
        if (input instanceof InputStream) {
            if (input instanceof FileInputStream) {
                return ((FileInputStream)input).getChannel();
            }
            return Channels.newChannel((InputStream)input);
        }
        if (input instanceof URL) {
            try {
                input = IOUtilities.toFile((URL)input, encoding);
            }
            catch (IOException e) {
                IOUtilities.recoverableException(e);
            }
        } else if (input instanceof URI) {
            URI uri = (URI)input;
            if (!uri.isAbsolute()) {
                throw new IOException(Errors.format((short)62));
            }
            try {
                input = new File(uri);
            }
            catch (IllegalArgumentException e) {
                input = uri.toURL();
                IOUtilities.recoverableException(e);
            }
        } else if (input instanceof CharSequence) {
            input = IOUtilities.toFileOrURL(input.toString(), encoding);
        }
        if (input instanceof URL) {
            return Channels.newChannel(((URL)input).openStream());
        }
        if (input instanceof File) {
            return Files.newByteChannel((File)input, optionSet);
        }
        return null;
    }

    private static void recoverableException(Exception warning) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.storage"), IOUtilities.class, "open", warning);
    }
}

