/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.nio.charset.Charset;
import java.util.Collections;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.Static;
import org.opengis.referencing.operation.TransformException;

public final class MetadataHelper
extends Static {
    private MetadataHelper() {
    }

    public static DefaultMetadata createForTextFile(StorageConnector connector) {
        DefaultMetadata metadata = new DefaultMetadata();
        Charset encoding = connector.getOption(OptionKey.ENCODING);
        if (encoding != null) {
            metadata.setCharacterSets(Collections.singleton(encoding));
        }
        return metadata;
    }

    public static void add(DefaultMetadata addTo, AbstractEnvelope envelope) throws TransformException {
        if (envelope != null) {
            addTo.setReferenceSystemInfo(Collections.singleton(envelope.getCoordinateReferenceSystem()));
            if (!envelope.isAllNaN()) {
                DefaultExtent extent = new DefaultExtent();
                extent.addElements(envelope);
                DefaultDataIdentification id = new DefaultDataIdentification();
                id.setExtents(Collections.singleton(extent));
                addTo.setIdentificationInfo(Collections.singleton(id));
            }
        }
    }
}

