/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import org.apache.sis.internal.jdk8.JDK8;

public final class Region {
    final long sourceLength;
    final int[] targetSize;
    final long startAt;
    final long[] skips;
    final int contiguousDataDimension;

    public Region(long[] size, long[] regionLower, long[] regionUpper, int[] subsamplings) {
        int dimension = size.length;
        this.targetSize = new int[dimension];
        this.skips = new long[dimension + 1];
        long position = 0L;
        long stride = 1L;
        long skip = 0L;
        int i = 0;
        while (i < dimension) {
            int step = subsamplings[i];
            long lower = regionLower[i];
            long count = (regionUpper[i] - lower + (long)(step - 1)) / (long)step;
            long upper = lower + ((count - 1L) * (long)step + 1L);
            long span = size[i];
            assert (count > 0L && lower >= 0L && upper > lower && upper <= span) : i;
            this.targetSize[i] = JDK8.toIntExact(count);
            position += stride * lower;
            int n = i++;
            this.skips[n] = this.skips[n] + stride * (long)(step - 1);
            this.skips[i] = skip += (stride *= span) * (span - (upper - lower));
        }
        this.startAt = position;
        this.sourceLength = stride;
        for (i = 0; i < dimension && this.skips[i] == 0L; ++i) {
        }
        this.contiguousDataDimension = i;
    }

    public final int getDimension() {
        return this.targetSize.length;
    }

    final int targetLength(int dimension) {
        long length = 1L;
        for (int i = 0; i < dimension; ++i) {
            length *= (long)this.targetSize[i];
        }
        return JDK8.toIntExact(length);
    }
}

