/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.logging.LogRecord;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.XML;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;

final class Store
extends DataStore {
    private final String name;
    private StreamSource source;
    private Object object;
    private Metadata metadata;

    public Store(StorageConnector connector) throws DataStoreException {
        this.name = connector.getStorageName();
        InputStream in = connector.getStorageAs(InputStream.class);
        if (in != null) {
            this.source = new StreamSource(in);
        } else {
            Reader reader = connector.getStorageAs(Reader.class);
            if (reader != null) {
                this.source = new StreamSource(reader);
            }
        }
        Closeable c = Store.input(this.source);
        connector.closeAllExcept(c);
        if (c == null) {
            throw new DataStoreException(Errors.format((short)7, this.name));
        }
    }

    private static Closeable input(StreamSource source) {
        Closeable in = null;
        if (source != null && (in = source.getInputStream()) == null) {
            in = source.getReader();
        }
        return in;
    }

    private Map<String, ?> properties() {
        if (this.listeners.hasListeners()) {
            return Collections.singletonMap("org.apache.sis.xml.warningListener", new WarningListener<Object>(){

                @Override
                public Class<Object> getSourceClass() {
                    return Object.class;
                }

                @Override
                public void warningOccured(Object source, LogRecord warning) {
                    Store.this.listeners.warning(warning);
                }
            });
        }
        return null;
    }

    private void unmarshal() throws DataStoreException {
        StreamSource s = this.source;
        Closeable in = Store.input(s);
        this.source = null;
        if (in != null) {
            try {
                try {
                    this.object = XML.unmarshal(s, this.properties());
                }
                finally {
                    in.close();
                }
            }
            catch (JAXBException e) {
                throw new DataStoreException(Errors.format((short)9, this.name), e);
            }
            catch (IOException e) {
                throw new DataStoreException(Errors.format((short)9, this.name), e);
            }
        }
    }

    @Override
    public Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.unmarshal();
            if (this.object instanceof Metadata) {
                this.metadata = (Metadata)this.object;
            } else if (this.object instanceof ReferenceSystem) {
                DefaultMetadata md = new DefaultMetadata();
                md.setReferenceSystemInfo(Collections.singleton((ReferenceSystem)this.object));
                this.metadata = md;
            }
        }
        return this.metadata;
    }

    @Override
    public void close() throws DataStoreException {
        this.object = null;
        Closeable in = Store.input(this.source);
        this.source = null;
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
    }
}

