/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.jdk7.Files;
import org.apache.sis.internal.jdk7.InvalidPathException;
import org.apache.sis.internal.jdk7.Path;
import org.apache.sis.internal.jdk7.Paths;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;

public enum DataDirectory {
    DATABASES,
    DATUM_CHANGES,
    DOMAINS_OF_VALIDITY;

    public static final String ENV = "SIS_DATA";
    private static short lastWarning;
    private static Path rootDirectory;
    private Path directory;

    private static void warning(String method, Exception e, short key, Object ... parameters) {
        if (key != lastWarning) {
            lastWarning = key;
            DataDirectory.log(Level.WARNING, method, e, key, parameters);
        }
    }

    private static void log(Level level, String method, Exception e, short key, Object ... parameters) {
        LogRecord record = Messages.getResources(null).getLogRecord(level, key, parameters);
        record.setLoggerName("org.apache.sis.system");
        if (e != null) {
            record.setThrown(e);
        }
        Logging.log(DataDirectory.class, method, record);
    }

    public static synchronized Path getRootDirectory() {
        block8: {
            if (rootDirectory == null) {
                try {
                    String dir = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getenv(DataDirectory.ENV);
                        }
                    });
                    if (dir == null || dir.isEmpty()) {
                        DataDirectory.warning("getRootDirectory", null, (short)22, ENV);
                        break block8;
                    }
                    try {
                        Path path = Paths.get(dir, new String[0]);
                        if (!Files.isDirectory(path)) {
                            DataDirectory.warning("getRootDirectory", null, (short)20, ENV, path);
                            break block8;
                        }
                        if (!Files.isReadable(path)) {
                            DataDirectory.warning("getRootDirectory", null, (short)21, ENV, path);
                            break block8;
                        }
                        DataDirectory.log(Level.CONFIG, "getRootDirectory", null, (short)24, ENV, path);
                        rootDirectory = path;
                    }
                    catch (InvalidPathException e) {
                        DataDirectory.warning("getRootDirectory", e, (short)20, ENV, dir);
                    }
                }
                catch (SecurityException e) {
                    DataDirectory.warning("getRootDirectory", e, (short)25, ENV);
                }
            }
        }
        return rootDirectory;
    }

    public synchronized Path getDirectory() {
        Path root;
        if (this.directory == null && (root = DataDirectory.getRootDirectory()) != null) {
            StringBuilder buffer = new StringBuilder(this.name());
            for (int i = 1; i < buffer.length(); ++i) {
                char c = buffer.charAt(i);
                if (c == '_') {
                    buffer.deleteCharAt(i);
                    continue;
                }
                buffer.setCharAt(i, Character.toLowerCase(c));
            }
            String name = buffer.toString();
            Path dir = root.resolve(name).normalize();
            try {
                if (Files.isDirectory(dir)) {
                    this.directory = dir;
                } else if (Files.isWritable(root)) {
                    try {
                        this.directory = Files.createDirectory(dir);
                    }
                    catch (IOException e) {
                        DataDirectory.warning("getDirectory", e, (short)23, ENV, root);
                    }
                } else {
                    DataDirectory.warning("getDirectory", null, (short)23, ENV, root);
                }
            }
            catch (SecurityException e) {
                DataDirectory.warning("getDirectory", e, (short)26, ENV, name);
            }
        }
        return this.directory;
    }

    public Path resolve(Path file) {
        Path dir;
        if (file != null && !file.isAbsolute() && (dir = this.getDirectory()) != null) {
            return dir.resolve(file);
        }
        return file;
    }
}

