/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class DelayedRunnable
implements Delayed,
Runnable {
    final long timestamp;

    protected DelayedRunnable(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.timestamp - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        if (other instanceof Immediate) {
            return 1;
        }
        return Long.signum(this.timestamp - ((DelayedRunnable)other).timestamp);
    }

    public static abstract class Immediate
    extends DelayedRunnable {
        private static final AtomicLong COUNTER = new AtomicLong(Long.MIN_VALUE);

        protected Immediate() {
            super(COUNTER.getAndIncrement());
        }

        @Override
        public final long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public final int compareTo(Delayed other) {
            if (other instanceof Immediate && this.timestamp > ((Immediate)other).timestamp) {
                return 1;
            }
            return -1;
        }
    }
}

