/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

public final class Semaphores {
    public static final byte CONVERSION_AND_CRS = 1;
    public static final byte ENCLOSED_IN_OPERATION = 2;
    public static final byte NULL_COLLECTION = 4;
    public static final byte SUSPEND_PARAMETER_CHECK = 8;
    private static final ThreadLocal<Semaphores> FLAGS = new ThreadLocal();
    private byte flags;

    private Semaphores() {
    }

    public static boolean query(byte flag) {
        Semaphores s = FLAGS.get();
        return s != null && (s.flags & flag) != 0;
    }

    public static boolean queryAndSet(byte flag) {
        Semaphores s = FLAGS.get();
        if (s == null) {
            s = new Semaphores();
            FLAGS.set(s);
        }
        boolean isSet = (s.flags & flag) != 0;
        s.flags = (byte)(s.flags | flag);
        return isSet;
    }

    public static void clear(byte flag) {
        Semaphores s = FLAGS.get();
        if (s != null) {
            s.flags = (byte)(s.flags & ~flag);
        }
    }
}

