/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.LinkedHashSet;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.collection.CheckedContainer;

public final class CheckedHashSet<E>
extends LinkedHashSet<E>
implements CheckedContainer<E> {
    private static final long serialVersionUID = 1999408533884863599L;
    private final Class<E> type;

    public CheckedHashSet(Class<E> type) {
        this.type = type;
        ArgumentChecks.ensureNonNull("type", type);
    }

    public CheckedHashSet(Class<E> type, int capacity) {
        super(capacity);
        this.type = type;
        ArgumentChecks.ensureNonNull("type", type);
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    @Override
    public boolean add(E element) throws IllegalArgumentException {
        if (this.type.isInstance(element)) {
            return super.add(element);
        }
        String message = CheckedArrayList.illegalElement(this, element, this.type);
        if (message == null) {
            return false;
        }
        if (element == null) {
            throw new NullArgumentException(message);
        }
        throw new IllegalArgumentException(message);
    }
}

