/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Static;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Citations
extends Static {
    private Citations() {
    }

    public static boolean isEPSG(String codeSpace, String code) {
        return "EPSG".equalsIgnoreCase(code) && ("IOGP".equalsIgnoreCase(codeSpace) || "OGP".equalsIgnoreCase(codeSpace) || "EPSG".equalsIgnoreCase(codeSpace));
    }

    public static <E> Iterator<E> iterator(Collection<E> collection) {
        return collection != null && !collection.isEmpty() ? collection.iterator() : null;
    }

    private static boolean isDeprecated(Object object) {
        return object instanceof Deprecable && ((Deprecable)object).isDeprecated();
    }

    private static String toString(InternationalString title) {
        return title != null && !Citations.isDeprecated(title) ? CharSequences.trimWhitespaces(title.toString(Locale.ROOT)) : null;
    }

    public static boolean equalsFiltered(CharSequence s1, CharSequence s2) {
        return CharSequences.equalsFiltered(s1, s2, Characters.Filter.LETTERS_AND_DIGITS, true);
    }

    public static boolean titleMatches(Citation c1, Citation c2) {
        if (c1 != null && c2 != null) {
            if (c1 == c2) {
                return true;
            }
            InternationalString candidate = c2.getTitle();
            Iterator<? extends InternationalString> iterator = null;
            while (true) {
                if (candidate != null) {
                    String unlocalized = candidate.toString(Locale.ROOT);
                    if (Citations.titleMatches(c1, unlocalized)) {
                        return true;
                    }
                    String localized = candidate.toString();
                    if (!Objects.equals(localized, unlocalized) && Citations.titleMatches(c1, localized)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = Citations.iterator(c2.getAlternateTitles())) == null || !iterator.hasNext()) break;
                candidate = iterator.next();
            }
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, CharSequence title) {
        if (citation != null && title != null) {
            InternationalString candidate = citation.getTitle();
            Iterator<? extends InternationalString> iterator = null;
            while (true) {
                if (candidate != null) {
                    String unlocalized = candidate.toString(Locale.ROOT);
                    if (Citations.equalsFiltered(unlocalized, title)) {
                        return true;
                    }
                    String localized = candidate.toString();
                    if (!Objects.equals(localized, unlocalized) && Citations.equalsFiltered(localized, title)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = Citations.iterator(citation.getAlternateTitles())) == null || !iterator.hasNext()) break;
                candidate = iterator.next();
            }
        }
        return false;
    }

    public static boolean identifierMatches(Citation c1, Citation c2) {
        if (c1 != null && c2 != null) {
            if (c1 == c2) {
                return true;
            }
            Iterator<? extends Identifier> iterator = Citations.iterator(c2.getIdentifiers());
            if (iterator == null) {
                iterator = Citations.iterator(c1.getIdentifiers());
                if (iterator == null) {
                    return Citations.titleMatches(c1, c2);
                }
                c1 = c2;
            }
            do {
                Identifier id;
                if ((id = iterator.next()) == null || !Citations.identifierMatches(c1, id, id.getCode())) continue;
                return true;
            } while (iterator.hasNext());
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, Identifier identifier, CharSequence code) {
        if (citation != null && code != null) {
            Iterator<? extends Identifier> identifiers = Citations.iterator(citation.getIdentifiers());
            if (identifiers == null) {
                return Citations.titleMatches(citation, code);
            }
            while (identifiers.hasNext()) {
                String cs;
                String codeSpace;
                Identifier id = identifiers.next();
                if (id == null || !Citations.equalsFiltered(code, id.getCode())) continue;
                if (identifier instanceof ReferenceIdentifier && (codeSpace = ((ReferenceIdentifier)identifier).getCodeSpace()) != null && id instanceof ReferenceIdentifier && (cs = ((ReferenceIdentifier)id).getCodeSpace()) != null) {
                    return Citations.equalsFiltered(codeSpace, cs);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean authorityMatches(Identifier identifier, Citation authority, String codeSpace) {
        Object other;
        if (authority != null && (other = identifier.getAuthority()) != null) {
            return Citations.identifierMatches(authority, (Citation)other);
        }
        if (codeSpace != null && identifier instanceof ReferenceIdentifier && (other = ((ReferenceIdentifier)identifier).getCodeSpace()) != null) {
            return CharSequences.equalsFiltered(codeSpace, (CharSequence)other, Characters.Filter.UNICODE_IDENTIFIER, true);
        }
        return false;
    }

    public static Boolean hasCommonIdentifier(Iterable<? extends Identifier> id1, Iterable<? extends Identifier> id2) {
        if (id1 != null && id2 != null) {
            boolean hasFound = false;
            for (Identifier identifier : id1) {
                Citation authority = identifier.getAuthority();
                String codeSpace = identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getCodeSpace() : null;
                for (Identifier identifier2 : id2) {
                    if (!Citations.authorityMatches(identifier, authority, codeSpace)) continue;
                    if (CharSequences.equalsFiltered(identifier.getCode(), identifier2.getCode(), Characters.Filter.UNICODE_IDENTIFIER, true)) {
                        return Boolean.TRUE;
                    }
                    hasFound = true;
                }
            }
            if (hasFound) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String getIdentifier(Citation citation, boolean strict) {
        if (citation != null) {
            String candidate;
            boolean isUnicode = false;
            String identifier = null;
            String codeSpace = null;
            Iterator<? extends Identifier> it = Citations.iterator(citation.getIdentifiers());
            if (it != null) {
                while (it.hasNext()) {
                    String cs;
                    Identifier id = it.next();
                    if (id == null || Citations.isDeprecated(id) || (candidate = CharSequences.trimWhitespaces(id.getCode())) == null || candidate.isEmpty()) continue;
                    String string = cs = id instanceof ReferenceIdentifier ? CharSequences.trimWhitespaces(((ReferenceIdentifier)id).getCodeSpace()) : null;
                    if (cs == null || cs.isEmpty()) {
                        cs = null;
                        isUnicode = CharSequences.isUnicodeIdentifier(candidate);
                    } else {
                        isUnicode = CharSequences.isUnicodeIdentifier(cs);
                        if (isUnicode) {
                            int c;
                            for (int i = 0; i < candidate.length(); i += Character.charCount(c)) {
                                c = candidate.codePointAt(i);
                                if (Character.isUnicodeIdentifierPart(c) || !strict && (c == 46 || c == 45)) continue;
                                isUnicode = false;
                                break;
                            }
                        }
                    }
                    if (identifier != null && !isUnicode) continue;
                    identifier = candidate;
                    codeSpace = cs;
                    if (!isUnicode) continue;
                    break;
                }
            }
            if (identifier == null) {
                Iterator<? extends InternationalString> iterator;
                identifier = Citations.toString(citation.getTitle());
                if (identifier != null) {
                    if (identifier.isEmpty()) {
                        identifier = null;
                    } else {
                        isUnicode = CharSequences.isUnicodeIdentifier(identifier);
                    }
                }
                if (!isUnicode && (iterator = Citations.iterator(citation.getAlternateTitles())) != null) {
                    while (iterator.hasNext()) {
                        candidate = Citations.toString(iterator.next());
                        if (candidate == null || candidate.isEmpty()) continue;
                        isUnicode = CharSequences.isUnicodeIdentifier(candidate);
                        if (identifier != null && !isUnicode) continue;
                        identifier = candidate;
                        if (!isUnicode) continue;
                        break;
                    }
                }
            }
            if (isUnicode || !strict) {
                if (codeSpace != null && !Citations.isEPSG(codeSpace, identifier)) {
                    return codeSpace + (strict ? (char)'_' : ':') + identifier;
                }
                return identifier;
            }
        }
        return null;
    }

    public static String getUnicodeIdentifier(Citation citation) {
        String identifier = Citations.getIdentifier(citation, true);
        if (identifier != null) {
            int n;
            int length = identifier.length();
            for (int i = 0; i < length; i += n) {
                int c = identifier.codePointAt(i);
                n = Character.charCount(c);
                if (!Character.isIdentifierIgnorable(c)) continue;
                StringBuilder buffer = new StringBuilder(length - n).append(identifier, 0, i);
                while ((i += n) < length) {
                    c = identifier.codePointAt(i);
                    n = Character.charCount(c);
                    if (Character.isIdentifierIgnorable(c)) continue;
                    buffer.appendCodePoint(c);
                }
                return buffer.toString();
            }
        }
        return identifier;
    }

    public static String getCodeSpace(Citation citation) {
        if (citation instanceof IdentifierSpace) {
            return ((IdentifierSpace)citation).getName();
        }
        return Citations.getUnicodeIdentifier(citation);
    }
}

