/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.sis.util.resources.Errors;

public class Cloner {
    private Class<?> type;
    private Method method;

    protected boolean isCloneRequired(Object object) {
        return true;
    }

    public Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        SecurityException security = null;
        Class<?> valueType = object.getClass();
        try {
            if (valueType != this.type) {
                this.method = valueType.getMethod("clone", null);
                this.type = valueType;
                if (!Modifier.isPublic(this.method.getDeclaringClass().getModifiers())) {
                    try {
                        this.method.setAccessible(true);
                    }
                    catch (SecurityException e) {
                        security = e;
                    }
                }
            }
            if (this.method != null) {
                return this.method.invoke(object, (Object[])null);
            }
        }
        catch (NoSuchMethodException e) {
            if (this.isCloneRequired(object)) {
                throw Cloner.fail(e, valueType);
            }
            this.method = null;
            this.type = valueType;
        }
        catch (IllegalAccessException e) {
            throw Cloner.fail(e, valueType);
        }
        catch (InvocationTargetException e) {
            Cloner.rethrow(e.getCause());
            throw Cloner.fail(e, valueType);
        }
        catch (SecurityException e) {
            throw Cloner.fail(e, valueType);
        }
        return object;
    }

    private static void rethrow(Throwable cause) throws CloneNotSupportedException {
        if (cause instanceof CloneNotSupportedException) {
            throw (CloneNotSupportedException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
    }

    private static CloneNotSupportedException fail(Throwable cause, Class<?> type) {
        return (CloneNotSupportedException)new CloneNotSupportedException(Errors.format((short)13, type)).initCause(cause);
    }

    public static Object cloneIfPublic(Object object) throws CloneNotSupportedException {
        if (object != null) {
            Class<?> type = object.getClass();
            try {
                Method m = type.getMethod("clone", null);
                if (Modifier.isPublic(m.getModifiers())) {
                    return m.invoke(object, (Object[])null);
                }
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                Cloner.rethrow(e.getCause());
                throw Cloner.fail(e, type);
            }
            catch (SecurityException e) {
                throw Cloner.fail(e, type);
            }
        }
        return object;
    }
}

