/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Collections;
import java.util.Map;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;

public final class DefinitionURI {
    public static final String PREFIX = "urn:ogc:def";
    public static final char SEPARATOR = ':';
    private static final String DOMAIN = "www.opengis.net";
    private static final Map<String, String> PATHS = Collections.singletonMap("crs", "//www.opengis.net/gml/srs/");
    public static final String NO_VERSION = "0";
    public boolean isHTTP;
    public boolean isGML;
    public String type;
    public String authority;
    public String version;
    public String code;
    public String[] parameters;

    private DefinitionURI() {
    }

    public static DefinitionURI parse(String uri) {
        ArgumentChecks.ensureNonNull("uri", uri);
        DefinitionURI result = null;
        int separator = 58;
        int upper = -1;
        block11: for (int p = 0; p <= 6; ++p) {
            int lower = upper + 1;
            if ((upper = uri.indexOf(separator, lower)) < 0 && lower > (upper = uri.length())) {
                return result;
            }
            switch (p) {
                case 0: {
                    if (DefinitionURI.regionMatches("http", uri, lower, upper)) {
                        result = new DefinitionURI();
                        result.isHTTP = true;
                        if (DefinitionURI.codeForGML(null, null, uri, ++upper, result) != null) {
                            return result;
                        }
                        if (!uri.regionMatches(upper, "//", 0, 2)) {
                            return null;
                        }
                        ++upper;
                        separator = 47;
                        continue block11;
                    }
                    if (DefinitionURI.regionMatches("urn", uri, lower, upper)) continue block11;
                    return null;
                }
                case 1: {
                    boolean isHTTP = separator != 58;
                    if (DefinitionURI.regionMatches(isHTTP ? DOMAIN : "ogc", uri, lower, upper) || !isHTTP && DefinitionURI.regionMatches("x-ogc", uri, lower, upper)) continue block11;
                    return null;
                }
                case 2: {
                    if (DefinitionURI.regionMatches("def", uri, lower, upper)) continue block11;
                    return null;
                }
                default: {
                    String value = CharSequences.trimWhitespaces(uri, lower, upper).toString();
                    if (value.isEmpty() || p == 5 && NO_VERSION.equals(value)) continue block11;
                    if (result == null) {
                        result = new DefinitionURI();
                    }
                    switch (p) {
                        case 3: {
                            result.type = value;
                            continue block11;
                        }
                        case 4: {
                            result.authority = value;
                            continue block11;
                        }
                        case 5: {
                            result.version = value;
                            continue block11;
                        }
                        case 6: {
                            result.code = value;
                            continue block11;
                        }
                    }
                    throw new AssertionError(p);
                }
            }
        }
        if (result != null && ++upper < uri.length()) {
            result.parameters = (String[])CharSequences.split(uri.substring(upper), (char)separator);
        }
        return result;
    }

    static boolean regionMatches(String component, String urn, int lower, int upper) {
        int length = (upper = CharSequences.skipTrailingWhitespaces(urn, lower = CharSequences.skipLeadingWhitespaces(urn, lower, upper), upper)) - lower;
        return length == component.length() && urn.regionMatches(true, lower, component, 0, length);
    }

    private static String codeIgnoreVersion(String urn, int fromIndex) {
        int length = urn.length();
        if ((fromIndex = CharSequences.skipLeadingWhitespaces(urn, fromIndex, length)) >= length) {
            return null;
        }
        int s = urn.indexOf(58, fromIndex);
        if (s >= 0 && ((fromIndex = CharSequences.skipLeadingWhitespaces(urn, s + 1, length)) >= length || urn.indexOf(58, fromIndex) >= 0)) {
            return null;
        }
        return urn.substring(fromIndex, CharSequences.skipTrailingWhitespaces(urn, fromIndex, length));
    }

    public static String codeOf(String type, String authority, String uri) {
        String component;
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("authority", authority);
        ArgumentChecks.ensureNonNull("uri", uri);
        int upper = uri.indexOf(58);
        if (upper < 0) {
            return CharSequences.trimWhitespaces(uri);
        }
        int lower = CharSequences.skipLeadingWhitespaces(uri, 0, upper);
        int length = CharSequences.skipTrailingWhitespaces(uri, lower, upper) - lower;
        if (length == authority.length() && uri.regionMatches(true, lower, authority, 0, length)) {
            return DefinitionURI.codeIgnoreVersion(uri, upper + 1);
        }
        switch (length) {
            case 3: {
                component = "urn";
                break;
            }
            case 4: {
                component = "http";
                break;
            }
            default: {
                return null;
            }
        }
        if (!uri.regionMatches(true, lower, component, 0, length)) {
            return null;
        }
        if (length == 4) {
            return DefinitionURI.codeForGML(type, authority, uri, upper + 1, null);
        }
        block10: for (int p = 0; p != 4; ++p) {
            lower = upper + 1;
            if ((upper = uri.indexOf(58, lower)) < 0) {
                return null;
            }
            switch (p) {
                case 0: {
                    if (DefinitionURI.regionMatches("ogc", uri, lower, upper)) continue block10;
                    component = "x-ogc";
                    break;
                }
                case 1: {
                    component = "def";
                    break;
                }
                case 2: {
                    component = type;
                    break;
                }
                case 3: {
                    component = authority;
                    break;
                }
                default: {
                    throw new AssertionError(p);
                }
            }
            if (DefinitionURI.regionMatches(component, uri, lower, upper)) continue;
            return null;
        }
        return DefinitionURI.codeIgnoreVersion(uri, upper + 1);
    }

    private static String codeForGML(String type, String authority, String url, int lower, DefinitionURI result) {
        String path;
        Map<String, String> paths = PATHS;
        if (type != null && (path = paths.get(type)) == null) {
            return null;
        }
        block4: for (Map.Entry<String, String> entry : paths.entrySet()) {
            int upper;
            String path2 = entry.getValue();
            if (!url.regionMatches(true, lower, path2, 0, path2.length())) continue;
            lower = CharSequences.skipLeadingWhitespaces(url, lower + path2.length(), url.length());
            if (authority == null) {
                authority = url.substring(lower, DefinitionURI.skipIdentifierPart(url, lower));
            } else if (!url.regionMatches(true, lower, authority, 0, authority.length())) continue;
            if ((lower += authority.length()) >= (upper = url.length())) continue;
            switch (url.charAt(lower)) {
                case '.': {
                    lower = url.indexOf(35, lower + 1);
                    if (lower < 0) continue block4;
                }
                case '#': {
                    String code = CharSequences.trimWhitespaces(url, lower + 1, upper).toString();
                    if (result != null) {
                        result.isGML = true;
                        result.type = entry.getKey();
                        result.authority = authority;
                        result.code = code;
                    }
                    return code;
                }
            }
        }
        return null;
    }

    private static int skipIdentifierPart(String text, int i) {
        int c;
        while (i < text.length() && Character.isUnicodeIdentifierPart(c = text.codePointAt(i))) {
            i += Character.charCount(c);
        }
        return i;
    }

    public static String format(String type, String authority, String version, String code) {
        StringBuilder buffer = new StringBuilder(PREFIX);
        for (int p = 0; p < 4; ++p) {
            String component;
            switch (p) {
                case 0: {
                    component = type;
                    break;
                }
                case 1: {
                    component = authority;
                    break;
                }
                case 2: {
                    component = version;
                    break;
                }
                case 3: {
                    component = code;
                    break;
                }
                default: {
                    throw new AssertionError(p);
                }
            }
            if (Utilities.appendUnicodeIdentifier(buffer.append(':'), '\u0000', component, ".-", false) || p == 2) continue;
            return null;
        }
        return buffer.toString();
    }

    public String toString() {
        String path;
        if (this.isGML && (path = PATHS.get(this.type)) != null) {
            return "http:" + path + this.authority + ".xml#" + this.code;
        }
        StringBuilder buffer = new StringBuilder(PREFIX);
        char separator = ':';
        if (this.isHTTP) {
            buffer.setLength(0);
            buffer.append("http://").append(DOMAIN).append("/def");
            separator = '/';
        }
        int n = 4;
        if (this.parameters != null) {
            n += this.parameters.length;
        }
        for (int p = 0; p < n; ++p) {
            String component;
            switch (p) {
                case 0: {
                    component = this.type;
                    break;
                }
                case 1: {
                    component = this.authority;
                    break;
                }
                case 2: {
                    component = this.version;
                    break;
                }
                case 3: {
                    component = this.code;
                    break;
                }
                default: {
                    component = this.parameters[p - 4];
                }
            }
            buffer.append(separator);
            if (component == null) {
                if (!this.isHTTP) continue;
                component = NO_VERSION;
            }
            buffer.append(component);
        }
        return buffer.toString();
    }
}

