/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Arrays;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;

public final class DoubleDouble
extends Number {
    private static final long serialVersionUID = -7602414219228638550L;
    public static final boolean DISABLED = false;
    private static final int ZERO_THRESHOLD = 2;
    private static final double SPLIT = 1.34217729E8;
    public static final double MAX_VALUE = 1.3393857490036326E300;
    private static final double[] VALUES = new double[]{4.84813681109536E-6, 2.777777777777778E-4, 0.002777777777777778, 0.016666666666666666, Math.PI / 180, 0.7853981633974483, 1.1111111111111112, 1.4142135623730951, 1.5707963267948966, 2.356194490192345, Math.PI, Math.PI * 2, 57.29577951308232};
    private static final double[] ERRORS = new double[]{9.320078015422868E-23, 2.4093381610788987E-22, -1.0601087908747154E-19, 2.312964634635743E-19, 2.9486522708701687E-19, 3.061616997868383E-17, -4.9343245538895844E-17, -9.667293313452913E-17, 6.123233995736766E-17, 9.184850993605148E-17, 1.2246467991473532E-16, 2.4492935982947064E-16, -1.9878495670576283E-15};
    public double value;
    public double error;

    public DoubleDouble() {
    }

    public DoubleDouble(DoubleDouble other) {
        this.value = other.value;
        this.error = other.error;
    }

    public DoubleDouble(Number otherValue) {
        this.value = otherValue.doubleValue();
        this.error = otherValue instanceof DoubleDouble ? ((DoubleDouble)otherValue).error : DoubleDouble.errorForWellKnownValue(this.value);
    }

    public DoubleDouble(double value) {
        this.value = value;
        this.error = DoubleDouble.errorForWellKnownValue(value);
    }

    public DoubleDouble(double value, double error) {
        this.value = value;
        this.error = error;
        assert (!(Math.abs(error) >= Math.ulp(value))) : this;
    }

    public static DoubleDouble verbatim(double value) {
        return new DoubleDouble(value, 0.0);
    }

    public static DoubleDouble createRadiansToDegrees() {
        return new DoubleDouble(57.29577951308232, -1.9878495670576283E-15);
    }

    public static DoubleDouble createDegreesToRadians() {
        return new DoubleDouble(Math.PI / 180, 2.9486522708701687E-19);
    }

    public static DoubleDouble createSecondsToRadians() {
        return new DoubleDouble(4.84813681109536E-6, 9.320078015422868E-23);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public long longValue() {
        return Math.round(this.value);
    }

    @Override
    public int intValue() {
        return JDK8.toIntExact(this.longValue());
    }

    public static double errorForWellKnownValue(double value) {
        int i = Arrays.binarySearch(VALUES, Math.abs(value));
        if (i >= 0) {
            return MathFunctions.xorSign(ERRORS[i], value);
        }
        double delta = DecimalFunctions.deltaForDoubleToDecimal(value);
        return Double.isNaN(delta) ? 0.0 : delta;
    }

    public boolean isZero() {
        return this.value == 0.0 && this.error == 0.0;
    }

    public void clear() {
        this.value = 0.0;
        this.error = 0.0;
    }

    public void setFrom(DoubleDouble other) {
        this.value = other.value;
        this.error = other.error;
    }

    public void setFrom(double[] array, int index, int errorOffset) {
        this.value = array[index];
        this.error = array[index + errorOffset];
    }

    final void normalize() {
        this.error += this.value - (this.value += this.error);
    }

    public void setToQuickSum(double a, double b) {
        this.value = a + b;
        this.error = b - (this.value - a);
    }

    public void setToSum(double a, double b) {
        this.value = a + b;
        double v = this.value - a;
        this.error = a - (this.value - v) + (b - v);
    }

    public void setToProduct(double a, double b) {
        this.value = a * b;
        double t = 1.34217729E8 * a;
        double ahi = t - (t - a);
        double alo = a - ahi;
        t = 1.34217729E8 * b;
        double bhi = t - (t - b);
        double blo = b - bhi;
        this.error = ahi * bhi - this.value + ahi * blo + alo * bhi + alo * blo;
    }

    public void storeTo(double[] array, int index, int errorOffset) {
        array[index] = this.value;
        array[index + errorOffset] = this.error;
    }

    public static void swap(double[] array, int i0, int i1, int errorOffset) {
        double t = array[i0];
        array[i0] = array[i1];
        array[i1] = t;
        t = array[i0 += errorOffset];
        array[i0] = array[i1 += errorOffset];
        array[i1] = t;
    }

    public void negate() {
        this.value = -this.value;
        this.error = -this.error;
    }

    public void add(DoubleDouble other) {
        this.add(other.value, other.error);
    }

    public void add(Number other) {
        if (other instanceof DoubleDouble) {
            this.add((DoubleDouble)other);
        } else {
            this.add(other.doubleValue());
        }
    }

    public void add(double otherValue) {
        this.add(otherValue, DoubleDouble.errorForWellKnownValue(otherValue));
    }

    public void add(double otherValue, double otherError) {
        double v = this.value;
        this.value += otherValue;
        this.error += v - (this.value + (v -= this.value)) + (otherValue + v);
        this.error += otherError;
        if (this.value == 0.0 && this.error != 0.0 && Math.abs(this.error) <= Math.scalb(Math.ulp(otherValue), -50)) {
            this.error = 0.0;
            return;
        }
        this.normalize();
    }

    public void add(double[] array, int index, int errorOffset) {
        this.add(array[index], array[index + errorOffset]);
    }

    public void subtract(DoubleDouble other) {
        this.subtract(other.value, other.error);
    }

    public void subtract(Number other) {
        if (other instanceof DoubleDouble) {
            this.subtract((DoubleDouble)other);
        } else {
            this.subtract(other.doubleValue());
        }
    }

    public void subtract(double otherValue) {
        this.subtract(otherValue, DoubleDouble.errorForWellKnownValue(otherValue));
    }

    public void subtract(double otherValue, double otherError) {
        this.add(-otherValue, -otherError);
    }

    public void subtract(double[] array, int index, int errorOffset) {
        this.subtract(array[index], array[index + errorOffset]);
    }

    public void multiply(DoubleDouble other) {
        this.multiply(other.value, other.error);
    }

    public void multiply(Number other) {
        if (other instanceof DoubleDouble) {
            this.multiply((DoubleDouble)other);
        } else {
            this.multiply(other.doubleValue());
        }
    }

    public void multiply(double otherValue) {
        this.multiply(otherValue, DoubleDouble.errorForWellKnownValue(otherValue));
    }

    public void multiply(double otherValue, double otherError) {
        double thisValue = this.value;
        double thisError = this.error;
        this.setToProduct(thisValue, otherValue);
        this.error += otherError * thisValue;
        this.error += otherValue * thisError;
        this.normalize();
    }

    public void multiply(double[] array, int index, int errorOffset) {
        this.multiply(array[index], array[index + errorOffset]);
    }

    public void divide(DoubleDouble other) {
        this.divide(other.value, other.error);
    }

    public void divide(Number other) {
        if (other instanceof DoubleDouble) {
            this.divide((DoubleDouble)other);
        } else {
            this.divide(other.doubleValue());
        }
    }

    public void divide(double otherValue) {
        this.divide(otherValue, DoubleDouble.errorForWellKnownValue(otherValue));
    }

    public void divide(double denominatorValue, double denominatorError) {
        double numeratorValue = this.value;
        double numeratorError = this.error;
        this.value = denominatorValue;
        this.error = denominatorError;
        this.inverseDivide(numeratorValue, numeratorError);
    }

    public void divide(double[] array, int index, int errorOffset) {
        this.divide(array[index], array[index + errorOffset]);
    }

    public void inverseDivide(DoubleDouble other) {
        this.inverseDivide(other.value, other.error);
    }

    public void inverseDivide(Number other) {
        if (other instanceof DoubleDouble) {
            this.inverseDivide((DoubleDouble)other);
        } else {
            this.inverseDivide(other.doubleValue());
        }
    }

    public void inverseDivide(double numeratorValue) {
        this.inverseDivide(numeratorValue, DoubleDouble.errorForWellKnownValue(numeratorValue));
    }

    public void inverseDivide(double numeratorValue, double numeratorError) {
        double denominatorValue = this.value;
        double quotient = numeratorValue / denominatorValue;
        this.multiply(quotient, 0.0);
        double productError = this.error;
        this.setToSum(numeratorValue, -this.value);
        this.error -= productError;
        this.error += numeratorError;
        this.setToQuickSum(quotient, (this.value + this.error) / denominatorValue);
    }

    public void inverseDivide(double[] array, int index, int errorOffset) {
        this.inverseDivide(array[index], array[index + errorOffset]);
    }

    public void ratio_1m_1p() {
        DoubleDouble numerator = new DoubleDouble(1.0, 0.0);
        numerator.subtract(this);
        this.add(1.0, 0.0);
        this.inverseDivide(numerator);
    }

    public void square() {
        this.multiply(this.value, this.error);
    }

    public void sqrt() {
        if (this.value != 0.0) {
            double thisValue = this.value;
            double thisError = this.error;
            double r = Math.sqrt(thisValue);
            this.setToProduct(r, r);
            this.subtract(thisValue, thisError);
            this.divide(-2.0 * r, 0.0);
            this.setToQuickSum(r, this.value);
        }
    }

    public void series(double ... coefficients) {
        DoubleDouble x = new DoubleDouble(this);
        this.value = coefficients[0];
        this.error = 0.0;
        int last = coefficients.length - 1;
        if (last >= 1) {
            DoubleDouble xn = new DoubleDouble(x);
            DoubleDouble t = new DoubleDouble(xn);
            for (int i = 1; i < last; ++i) {
                t.multiply(coefficients[i], 0.0);
                this.add(t);
                xn.multiply(x);
                t.setFrom(xn);
            }
            t.multiply(coefficients[last], 0.0);
            this.add(t);
        }
    }

    public int hashCode() {
        return Numerics.hashCode(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.error));
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleDouble) {
            DoubleDouble other = (DoubleDouble)obj;
            return Numerics.equals(this.value, other.value) && Numerics.equals(this.error, other.error);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

