/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.sis.internal.util.LocalizedException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;

public final class LocalizedParseException
extends ParseException
implements LocalizedException,
Localized {
    private static final long serialVersionUID = -1467571540435486742L;
    private final Locale locale;
    private final short key;
    private final Object[] arguments;

    public LocalizedParseException(Locale locale, short key, Object[] arguments, int errorOffset) {
        super(Errors.format(key, arguments), errorOffset);
        this.locale = locale;
        this.arguments = arguments;
        this.key = key;
    }

    public LocalizedParseException(Locale locale, short key, CharSequence text, int errorOffset) {
        this(locale, key, new Object[]{CharSequences.token(text, errorOffset)}, errorOffset);
    }

    public LocalizedParseException(Locale locale, Class<?> type, CharSequence text, ParsePosition pos) {
        this(locale, type, text, pos != null ? pos.getIndex() : 0, pos != null ? pos.getErrorIndex() : 0);
    }

    private LocalizedParseException(Locale locale, Class<?> type, CharSequence text, int offset, int errorOffset) {
        this(locale, LocalizedParseException.arguments(type, text, offset, Math.max(offset, errorOffset)), errorOffset);
    }

    private LocalizedParseException(Locale locale, Object[] arguments, int errorOffset) {
        this(locale, LocalizedParseException.key(arguments), arguments, errorOffset);
    }

    private static Object[] arguments(Class<?> type, CharSequence text, int offset, int errorOffset) {
        if (errorOffset >= text.length()) {
            return new Object[]{text};
        }
        CharSequence erroneous = CharSequences.token(text = text.subSequence(offset, text.length()), errorOffset);
        if (erroneous.length() == 0) {
            return new Object[]{type, text};
        }
        return new Object[]{type, text, erroneous};
    }

    private static short key(Object[] arguments) {
        short key;
        switch (arguments.length) {
            case 1: {
                key = 110;
                break;
            }
            case 2: {
                key = 124;
                break;
            }
            case 3: {
                key = 125;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return key;
    }

    @Override
    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.getDefault();
    }

    @Override
    public String getLocalizedMessage() {
        return Errors.getResources(this.locale).getString(this.key, this.arguments);
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return Errors.getResources(locale).getString(this.key, this.arguments);
    }
}

