/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;

public final class Numerics
extends Static {
    private static final Map<Object, Object> CACHE = new HashMap<Object, Object>(32);
    public static final double COMPARISON_THRESHOLD = 1.0E-13;
    public static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    public static final int SIGNIFICAND_SIZE = 52;
    public static final int SIGNIFICAND_SIZE_OF_FLOAT = 23;

    private static void cache(double value) {
        Double boxed = value;
        CACHE.put(boxed, boxed);
        boxed = -value;
        CACHE.put(boxed, boxed);
    }

    private Numerics() {
    }

    public static <T> T cached(T value) {
        Object candidate = CACHE.get(value);
        return (T)(candidate != null ? candidate : value);
    }

    public static Double valueOf(double value) {
        Double boxed = value;
        Object candidate = CACHE.get(boxed);
        return candidate != null ? (Double)candidate : boxed;
    }

    public static float[] copyAsFloats(double[] data) {
        if (data == null) {
            return null;
        }
        float[] result = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = (float)data[i];
        }
        return result;
    }

    public static int[] copyAsInts(double[] data) {
        if (data == null) {
            return null;
        }
        int[] result = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = JDK8.toIntExact(Math.round(data[i]));
        }
        return result;
    }

    public static boolean equals(float v1, float v2) {
        return Float.floatToIntBits(v1) == Float.floatToIntBits(v2);
    }

    public static boolean equals(double v1, double v2) {
        return Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
    }

    public static boolean equalsIgnoreZeroSign(double v1, double v2) {
        return v1 == v2 || Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
    }

    public static boolean epsilonEqual(double v1, double v2, double threshold) {
        return Math.abs(v1 - v2) <= threshold || Numerics.equals(v1, v2);
    }

    public static boolean epsilonEqual(double v1, double v2, ComparisonMode mode) {
        double mg;
        if (mode.isApproximative() && (mg = Math.max(Math.abs(v1), Math.abs(v2))) != Double.POSITIVE_INFINITY) {
            return Numerics.epsilonEqual(v1, v2, 1.0E-13 * mg);
        }
        return Numerics.equals(v1, v2);
    }

    public static String messageForDifference(String name, double v1, double v2) {
        StringBuilder builder = new StringBuilder();
        if (name != null) {
            builder.append(name).append(": ");
        }
        builder.append("values ").append(v1).append(" and ").append(v2).append(" differ");
        float delta = (float)Math.abs(v1 - v2);
        if (delta < Float.POSITIVE_INFINITY) {
            builder.append(" by ").append(delta);
        }
        return builder.toString();
    }

    public static int hashCode(long c) {
        return (int)c ^ (int)(c >>> 32);
    }

    public static int toExp10(int exp2) {
        assert (exp2 >= -2620 && exp2 <= 2620) : exp2;
        return exp2 * 315653 >> 20;
    }

    public static long getSignificand(double value) {
        long bits = Double.doubleToRawLongBits(value);
        long exponent = bits & 0x7FF0000000000000L;
        bits &= 0xFFFFFFFFFFFFFL;
        bits = exponent != 0L ? (bits |= 0x10000000000000L) : (bits <<= 1);
        return bits;
    }

    public static int getSignificand(float value) {
        int bits = Float.floatToRawIntBits(value);
        int exponent = bits & 0x7F800000;
        bits = (int)((long)bits & 0x7FFFFFL);
        bits = exponent != 0 ? (int)((long)bits | 0x800000L) : (bits <<= 1);
        return bits;
    }

    static {
        Numerics.cache(0.0);
        Numerics.cache(1.0);
        Numerics.cache(10.0);
        Numerics.cache(60.0);
        Numerics.cache(90.0);
        Numerics.cache(100.0);
        Numerics.cache(180.0);
        Numerics.cache(648000.0);
        Numerics.cache(360.0);
        Numerics.cache(1000.0);
        Numerics.cache(Double.POSITIVE_INFINITY);
        Numerics.cache(Double.NaN);
    }
}

