/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.sis.measure.Units;

public final class PatchedUnitFormat
extends Format {
    private static final long serialVersionUID = -3064428584419360693L;
    private static volatile Map<Unit<?>, String> SYMBOLS;
    private final UnitFormat format;
    public boolean isLocaleUS;

    public static void init(Object ... entries) {
        HashMap symbols = new HashMap(8);
        for (int i = 0; i < entries.length; ++i) {
            String uom;
            if (symbols.put((Unit)entries[i], uom = (String)entries[++i]) == null) continue;
            throw new IllegalArgumentException(uom);
        }
        if (SYMBOLS != null) {
            throw new IllegalStateException();
        }
        SYMBOLS = symbols;
    }

    public PatchedUnitFormat(UnitFormat format) {
        this.format = format;
    }

    public static <Q extends Quantity> Unit<Q> toFormattable(Unit<Q> unit) {
        Map<Unit<?>, String> symbols = SYMBOLS;
        if (symbols != null && symbols.containsKey(unit)) {
            assert (Units.isAngular(unit));
            unit = NonSI.DEGREE_ANGLE;
        }
        return unit;
    }

    public static String toString(Unit<?> unit) {
        if (unit != null) {
            String symbol;
            Map<Unit<?>, String> symbols = SYMBOLS;
            if (symbols != null && (symbol = symbols.get(unit)) != null) {
                return symbol;
            }
            try {
                String text = unit.toString();
                if (text.equals("deg")) {
                    text = "\u00b0";
                }
                return text;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StringBuffer format(Object unit, StringBuffer toAppendTo, FieldPosition pos) {
        String symbol;
        Map<Unit<?>, String> symbols = SYMBOLS;
        if (symbols != null && (symbol = symbols.get(unit)) != null) {
            return toAppendTo.append(symbol);
        }
        if (Unit.ONE.equals(unit)) {
            return toAppendTo.append("unity");
        }
        if (NonSI.DEGREE_ANGLE.equals(unit)) {
            return toAppendTo.append("degree");
        }
        if (SI.METRE.equals(unit)) {
            return toAppendTo.append(this.isLocaleUS ? "meter" : "metre");
        }
        if (NonSI.FOOT_SURVEY_US.equals(unit)) {
            return toAppendTo.append("US survey foot");
        }
        if (Units.PPM.equals(unit)) {
            return toAppendTo.append("parts per million");
        }
        return this.format.format(unit, toAppendTo, pos);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.format.parseObject(source, pos);
    }
}

