/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.sis.util.ArraysExt;

public abstract class SetOfUnknownSize<E>
extends AbstractSet<E> {
    protected SetOfUnknownSize() {
    }

    protected boolean isSizeKnown() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.isSizeKnown() ? super.isEmpty() : !this.iterator().hasNext();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            modified |= this.remove(it.next());
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        return this.isSizeKnown() ? super.toArray() : this.toArray(new Object[32], true);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.isSizeKnown() ? super.toArray(array) : this.toArray(array, false);
    }

    private <T> T[] toArray(T[] array, boolean trimToSize) {
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (i >= array.length) {
                if (i >= 0x3FFFFFFF) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                array = Arrays.copyOf(array, Math.max(16, array.length) << 1);
                trimToSize = true;
            }
            array[i++] = it.next();
        }
        if (trimToSize) {
            array = ArraysExt.resize(array, i);
        } else {
            Arrays.fill(array, i, array.length, null);
        }
        return array;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set that = (Set)object;
        int size = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!that.contains(it.next())) {
                return false;
            }
            ++size;
        }
        return size == that.size();
    }
}

