/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class StandardDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = 1552761359761440473L;
    public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss.S";
    public static final String SHORT_PATTERN = "yyyy-MM-dd";

    public StandardDateFormat() {
        this(Locale.CANADA);
    }

    public StandardDateFormat(Locale locale) {
        this(locale, TimeZone.getTimeZone("UTC"));
    }

    public StandardDateFormat(Locale locale, TimeZone timezone) {
        super("UTC".equals(timezone.getID()) ? "yyyy-MM-dd'T'HH:mm:ss.S'Z'" : PATTERN, locale);
        this.setTimeZone(timezone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date parse(String text, ParsePosition position) {
        Date date = super.parse(text, position);
        if (date == null) {
            String pattern = this.toPattern();
            if (pattern.startsWith(SHORT_PATTERN)) {
                int errorIndex = position.getErrorIndex();
                position.setErrorIndex(-1);
                this.applyPattern(SHORT_PATTERN);
                try {
                    date = this.parse(text, position);
                }
                finally {
                    this.applyPattern(pattern);
                }
                if (date == null) {
                    position.setErrorIndex(errorIndex);
                }
            }
        } else {
            int p = position.getIndex();
            if (p < text.length() && text.charAt(p) == 'Z') {
                long time;
                position.setIndex(p + 1);
                Calendar cal = this.calendar;
                int year = cal.get(1);
                int month = cal.get(2);
                int day = cal.get(5);
                int hour = cal.get(11);
                int minute = cal.get(12);
                int second = cal.get(13);
                int millis = cal.get(14);
                TimeZone timezone = cal.getTimeZone();
                try {
                    cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                    cal.set(year, month, day, hour, minute, second);
                    cal.set(14, millis);
                    time = cal.getTimeInMillis();
                }
                finally {
                    cal.setTimeZone(timezone);
                }
                date.setTime(time);
            }
        }
        return date;
    }
}

