/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Date;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.geoapi.temporal.Period;
import org.apache.sis.internal.geoapi.temporal.TemporalFactory;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class TemporalUtilities
extends Static {
    public static final boolean REPORT_MISSING_MODULE = false;

    private TemporalUtilities() {
    }

    public static TemporalFactory getTemporalFactory() throws UnsupportedOperationException {
        TemporalFactory factory = DefaultFactories.forClass(TemporalFactory.class);
        if (factory != null) {
            return factory;
        }
        throw new UnsupportedOperationException(Errors.format((short)61, "sis-temporal"));
    }

    private static Instant createInstant(TemporalFactory factory, Date date) {
        return factory.createInstant(date);
    }

    public static Instant createInstant(Date time) throws UnsupportedOperationException {
        return TemporalUtilities.createInstant(TemporalUtilities.getTemporalFactory(), time);
    }

    public static Period createPeriod(Date begin, Date end) throws UnsupportedOperationException {
        TemporalFactory factory = TemporalUtilities.getTemporalFactory();
        return factory.createPeriod(TemporalUtilities.createInstant(factory, begin), TemporalUtilities.createInstant(factory, end));
    }
}

