/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Formatter;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;

public final class Utilities
extends Static {
    private Utilities() {
    }

    public static boolean isSIS(Class<?> type) {
        return type.getName().startsWith("org.apache.sis.");
    }

    public static boolean appendUnicodeIdentifier(StringBuilder appendTo, char separator, String text, String accepted, boolean toLowerCase) {
        boolean added = false;
        boolean toUpperCase = false;
        if (text != null) {
            int c;
            for (int i = 0; i < text.length(); i += Character.charCount(c)) {
                boolean isFirst;
                c = text.codePointAt(i);
                boolean bl = isFirst = appendTo.length() == 0;
                if ((!isFirst ? Character.isUnicodeIdentifierPart(c) : Character.isUnicodeIdentifierStart(c)) || accepted.indexOf(c) >= 0) {
                    if (!isFirst && !added && separator != '\u0000') {
                        appendTo.append(separator);
                    }
                    appendTo.appendCodePoint(toLowerCase ? Character.toLowerCase(c) : (toUpperCase ? Character.toUpperCase(c) : c));
                    added = true;
                    toUpperCase = false;
                    continue;
                }
                toUpperCase = true;
            }
        }
        return added;
    }

    public static String toString(Class<?> classe, Object ... properties) {
        StringBuffer buffer = new StringBuffer(32).append(Classes.getShortName(classe)).append('[');
        boolean isNext = false;
        for (int i = 0; i < properties.length; ++i) {
            Object value;
            if ((value = properties[++i]) == null) continue;
            if (isNext) {
                buffer.append(", ");
            }
            buffer.append(properties[i - 1]).append('=');
            boolean isText = value instanceof CharSequence;
            if (isText) {
                buffer.append('\u201c');
            }
            buffer.append(value);
            if (isText) {
                buffer.append('\u201d');
            }
            isNext = true;
        }
        return buffer.append(']').toString();
    }

    public static void formatTo(Formatter formatter, int flags, int width, int precision, String value) {
        Object[] args;
        String format;
        boolean isUpperCase;
        boolean bl = isUpperCase = (flags & 2) != 0;
        if (isUpperCase && width > 0) {
            value = value.toUpperCase(formatter.locale());
            isUpperCase = false;
        }
        int length = value.length();
        if (precision >= 0) {
            int n = 0;
            for (int i = 0; i < length; i += n) {
                if (--precision < 0) {
                    if (n == 0) {
                        value = "";
                        break;
                    }
                    length = (i -= n) + 1;
                    StringBuilder buffer = new StringBuilder(length);
                    value = buffer.append(value, 0, i).append('\u2026').toString();
                    break;
                }
                n = Character.charCount(value.codePointAt(i));
            }
        }
        if (width > length && (width -= value.codePointCount(0, length)) > 0) {
            format = "%s%s";
            args = new Object[]{value, value};
            args[(flags & 1) != 0 ? 1 : 0] = CharSequences.spaces(width);
        } else {
            format = isUpperCase ? "%S" : "%s";
            args = new Object[]{value};
        }
        formatter.format(format, args);
    }
}

