/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Numbers;

final class DefaultFormat
extends Format {
    private static final long serialVersionUID = -2309270763519060316L;
    private static final Format[] INSTANCES = new Format[7];
    private final Class<?> type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Format getInstance(Class<?> type) {
        int index;
        if (type == Number.class) {
            index = 0;
        } else {
            index = Numbers.getEnumConstant(type) - 2;
            if (index < 0 || index >= INSTANCES.length) {
                return null;
            }
        }
        Format[] formatArray = INSTANCES;
        synchronized (INSTANCES) {
            Format format = INSTANCES[index];
            if (format == null) {
                DefaultFormat.INSTANCES[index] = format = new DefaultFormat(type);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return format;
        }
    }

    private DefaultFormat(Class<?> type) {
        this.type = type;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(obj);
    }

    private Object valueOf(String source) throws NumberFormatException {
        return this.type != Number.class ? Numbers.valueOf(source, this.type) : Numbers.narrowestNumber(source);
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        source = CharSequences.trimWhitespaces(source);
        try {
            return this.valueOf(source);
        }
        catch (NumberFormatException cause) {
            LocalizedParseException e = new LocalizedParseException(null, this.type, (CharSequence)source, null);
            e.initCause(cause);
            throw e;
        }
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int length = source.length();
        int index = CharSequences.skipLeadingWhitespaces(source, pos.getIndex(), length);
        source = source.substring(index, CharSequences.skipTrailingWhitespaces(source, index, length));
        try {
            return this.valueOf(source);
        }
        catch (NumberFormatException cause) {
            pos.setErrorIndex(index);
            return null;
        }
    }

    private Object readResolve() {
        Format format = DefaultFormat.getInstance(this.type);
        return format != null ? format : this;
    }
}

