/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

final class IdentifiedObjectFormat
extends Format {
    private static final long serialVersionUID = -832517434580782189L;
    private final Locale locale;

    IdentifiedObjectFormat(Locale locale) {
        this.locale = locale;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        ReferenceIdentifier identifier = ((IdentifiedObject)obj).getName();
        if (identifier == null) {
            return toAppendTo.append(Vocabulary.getResources(this.locale).getString((short)65));
        }
        if (identifier instanceof GenericName) {
            return toAppendTo.append(((GenericName)((Object)identifier)).toInternationalString().toString(this.locale));
        }
        String code = identifier.getCode();
        String cs = identifier.getCodeSpace();
        if (cs == null || cs.isEmpty()) {
            cs = Citations.getIdentifier(identifier.getAuthority(), true);
        }
        if (cs != null) {
            toAppendTo.append(cs).append(':');
        }
        return toAppendTo.append(code);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }
}

