/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.opengis.referencing.cs.CoordinateSystem;

final class Element
implements Serializable {
    private static final long serialVersionUID = 2366817541632131955L;
    private static final int NUMERIC = 1;
    private static final int TEMPORAL = 2;
    private static final String[] TIME_KEYWORDS = new String[]{"TimeOrigin", "TimeExtent"};
    final int offset;
    private byte keywordIndex;
    public final String keyword;
    private final List<Object> list;
    private final Locale locale;

    Element(String name, Element singleton) {
        this.keyword = name;
        this.offset = singleton.offset;
        this.locale = singleton.locale;
        this.list = new LinkedList<Object>();
        this.list.add(singleton);
    }

    Element(Element toCopy) {
        this.keyword = toCopy.keyword;
        this.offset = toCopy.offset;
        this.locale = toCopy.locale;
        this.list = new LinkedList<Object>(toCopy.list);
        ListIterator<Object> it = this.list.listIterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (!(value instanceof Element)) continue;
            Element fragment = (Element)value;
            if (fragment.list == null) continue;
            it.set(new Element(fragment));
        }
    }

    Element(AbstractParser parser, String text, ParsePosition position, Map<Object, Object> sharedValues) throws ParseException {
        int openingBracket;
        int closingBracket;
        int c;
        this.locale = parser.errorLocale;
        this.offset = position.getIndex();
        int length = text.length();
        int lower = CharSequences.skipLeadingWhitespaces(text, this.offset, length);
        int n = c = lower < length ? text.codePointAt(lower) : 0;
        if (!Character.isUnicodeIdentifierStart(c)) {
            this.keyword = text;
            position.setErrorIndex(lower);
            throw this.unparsableString(text, position);
        }
        int upper = lower;
        while ((upper += Character.charCount(c)) < length && Character.isUnicodeIdentifierPart(c = text.codePointAt(upper))) {
        }
        this.keyword = text.substring(lower, upper);
        lower = CharSequences.skipLeadingWhitespaces(text, upper, length);
        int valueType = 0;
        if (lower >= length || (closingBracket = parser.symbols.matchingBracket(openingBracket = text.codePointAt(lower))) < 0) {
            position.setIndex(lower);
            this.list = null;
            return;
        }
        lower = CharSequences.skipLeadingWhitespaces(text, lower + Character.charCount(openingBracket), length);
        LinkedList<Object> list = new LinkedList<Object>();
        String separator = parser.symbols.trimmedSeparator();
        while (lower < length) {
            int firstChar = text.codePointAt(lower);
            if (firstChar == 36) {
                int upper2;
                String id;
                Element fragment;
                if ((fragment = parser.fragments.get(id = text.substring(++lower, upper2 = AbstractParser.endOfFragmentName(text, lower)))) == null) {
                    position.setIndex(this.offset);
                    position.setErrorIndex(lower);
                    throw new LocalizedParseException(this.locale, 196, new Object[]{id}, lower);
                }
                if (fragment.list != null) {
                    fragment = new Element(fragment);
                }
                list.add(fragment);
                lower = upper2;
            } else if (Character.isUnicodeIdentifierStart(firstChar)) {
                if (lower != (lower = Element.regionMatches(text, lower, "true"))) {
                    list.add(Boolean.TRUE);
                } else if (lower != (lower = Element.regionMatches(text, lower, "false"))) {
                    list.add(Boolean.FALSE);
                } else {
                    position.setIndex(lower);
                    list.add(new Element(parser, text, position, sharedValues));
                    lower = position.getIndex();
                }
            } else {
                Date e;
                Object value;
                int closingQuote = parser.symbols.matchingQuote(firstChar);
                if (closingQuote >= 0) {
                    int upper3;
                    int n2 = Character.charCount(closingQuote);
                    lower += Character.charCount(firstChar) - n2;
                    CharSequence content = null;
                    do {
                        if ((upper3 = text.indexOf(closingQuote, lower += n2)) < lower) {
                            throw this.missingCharacter(closingQuote, lower, position);
                        }
                        if (content == null) {
                            content = text.substring(lower, upper3);
                            continue;
                        }
                        if (content instanceof String) {
                            content = new StringBuilder((String)content);
                        }
                        ((StringBuilder)content).appendCodePoint(closingQuote).append(text, lower, upper3);
                    } while ((lower = upper3 + n2) < text.length() && text.codePointAt(lower) == closingQuote);
                    value = CharSequences.trimWhitespaces(content).toString();
                } else {
                    position.setIndex(lower);
                    if (valueType == 0) {
                        valueType = ArraysExt.containsIgnoreCase(TIME_KEYWORDS, this.keyword) ? 2 : 1;
                    }
                    switch (valueType) {
                        case 2: {
                            value = parser.parseDate(text, position);
                            break;
                        }
                        case 1: {
                            value = parser.parseNumber(text, position);
                            break;
                        }
                        default: {
                            throw new AssertionError(valueType);
                        }
                    }
                    if (value == null) {
                        throw this.unparsableString(text, position);
                    }
                    lower = position.getIndex();
                }
                if (sharedValues != null && (e = JDK8.putIfAbsent(sharedValues, value, value)) != null) {
                    value = e;
                }
                list.add(value);
            }
            lower = CharSequences.skipLeadingWhitespaces(text, lower, length);
            if (text.regionMatches(lower, separator, 0, separator.length())) {
                lower = CharSequences.skipLeadingWhitespaces(text, lower + separator.length(), length);
                continue;
            }
            if (lower >= length) break;
            int c2 = text.codePointAt(lower);
            if (c2 == closingBracket) {
                position.setIndex(lower + Character.charCount(c2));
                this.list = sharedValues != null ? UnmodifiableArrayList.wrap(list.toArray()) : list;
                return;
            }
            position.setErrorIndex(lower);
            throw this.unparsableString(text, position);
        }
        throw this.missingCharacter(closingBracket, lower, position);
    }

    private static int regionMatches(String text, int index, String word) {
        int end;
        if (text.regionMatches(true, index, word, 0, word.length()) && ((end = index + word.length()) >= text.length() || !Character.isUnicodeIdentifierPart(text.codePointAt(end)))) {
            return end;
        }
        return index;
    }

    final ParseException parseFailed(Exception cause) {
        return (ParseException)new LocalizedParseException(this.locale, 190, new String[]{this.keyword, Exceptions.getLocalizedMessage(cause, this.locale)}, this.offset).initCause(cause);
    }

    private ParseException unparsableString(String text, ParsePosition position) {
        CharSequence[] arguments;
        short errorKey;
        int length;
        int errorIndex = Math.max(this.offset, position.getErrorIndex());
        if (errorIndex == (length = text.length())) {
            errorKey = 110;
            arguments = new String[]{this.keyword};
        } else {
            errorKey = 187;
            arguments = new CharSequence[]{this.keyword, CharSequences.token(text, errorIndex)};
        }
        position.setIndex(this.offset);
        return new LocalizedParseException(this.locale, errorKey, arguments, errorIndex);
    }

    private ParseException missingCharacter(int c, int errorIndex, ParsePosition position) {
        position.setIndex(this.offset);
        position.setErrorIndex(errorIndex);
        StringBuilder buffer = new StringBuilder(2).appendCodePoint(c);
        return new LocalizedParseException(this.locale, 188, new CharSequence[]{this.keyword, buffer}, errorIndex);
    }

    final ParseException missingComponent(String key) {
        int error = this.offset;
        if (this.keyword != null) {
            error += this.keyword.length();
        }
        return new LocalizedParseException(this.locale, 189, new String[]{this.keyword, key}, error);
    }

    final ParseException missingOrUnknownComponent(String expected) {
        Object[] args;
        short res;
        String name = null;
        for (Object child : this.list) {
            if (child instanceof Element && (name = ((Element)child).keyword) != null) break;
        }
        if (name != null) {
            res = 192;
            args = new String[]{name};
        } else {
            res = 189;
            args = new String[]{this.keyword, expected};
        }
        return new LocalizedParseException(this.locale, res, args, this.offset);
    }

    final ParseException illegalCS(CoordinateSystem cs) {
        String value;
        short key;
        if (cs == null) {
            key = 95;
            value = "coordinateSystem";
        } else {
            key = 193;
            value = cs.getName().getCode();
        }
        return new LocalizedParseException(this.locale, key, new String[]{value}, this.offset);
    }

    public Object peekValue() {
        for (Object object : this.list) {
            if (object instanceof Element) continue;
            return object;
        }
        return null;
    }

    public Date pullDate(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Date)) continue;
            iterator.remove();
            return (Date)object;
        }
        throw this.missingComponent(key);
    }

    public double pullDouble(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            return ((Number)object).doubleValue();
        }
        throw this.missingComponent(key);
    }

    public int pullInteger(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            Number number = (Number)object;
            if (number instanceof Float || number instanceof Double) {
                throw new LocalizedParseException(this.locale, 124, new Object[]{Integer.class, number}, this.offset);
            }
            return number.intValue();
        }
        throw this.missingComponent(key);
    }

    public boolean pullBoolean(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Boolean)) continue;
            iterator.remove();
            return (Boolean)object;
        }
        throw this.missingComponent(key);
    }

    public String pullString(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.remove();
            return (String)object;
        }
        throw this.missingComponent(key);
    }

    public Object pullObject(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null || object instanceof Element) continue;
            iterator.remove();
            return object;
        }
        throw this.missingComponent(key);
    }

    public Element pullElement(int mode, String ... keys) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list == null) continue;
            for (int i = 0; i < keys.length; ++i) {
                if (!element.keyword.equalsIgnoreCase(keys[i])) continue;
                element.keywordIndex = (byte)i;
                iterator.remove();
                return element;
            }
            if (mode != 0) continue;
            return null;
        }
        if (mode != 2) {
            return null;
        }
        throw this.missingComponent(keys[0]);
    }

    public Element pullVoidElement(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list != null) continue;
            iterator.remove();
            return element;
        }
        throw this.missingComponent(key);
    }

    public <T> T pullOptional(Class<T> type) {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!type.isInstance(object) || object instanceof Element) continue;
            iterator.remove();
            return (T)object;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    final int getKeywordIndex() {
        return this.keywordIndex;
    }

    final void close(Map<String, List<String>> ignoredElements) throws ParseException {
        if (this.list != null) {
            for (Object value : this.list) {
                if (value instanceof Element) {
                    CollectionsExt.addToMultiValuesMap(ignoredElements, ((Element)value).keyword, this.keyword);
                    continue;
                }
                throw new LocalizedParseException(this.locale, 191, new Object[]{this.keyword, value}, this.offset + this.keyword.length());
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.format(buffer, 0, JDK7.lineSeparator());
        return buffer.toString();
    }

    private void format(StringBuilder buffer, int margin, String lineSeparator) {
        buffer.append(CharSequences.spaces(margin)).append(this.keyword);
        if (this.list != null) {
            buffer.append('[');
            margin += 4;
            boolean addSeparator = false;
            for (Object value : this.list) {
                if (value instanceof Element) {
                    if (addSeparator) {
                        buffer.append(',');
                    }
                    buffer.append(lineSeparator);
                    ((Element)value).format(buffer, margin, lineSeparator);
                } else {
                    boolean quote = value instanceof CharSequence;
                    if (addSeparator) {
                        buffer.append(", ");
                    }
                    if (quote) {
                        buffer.append('\u201c');
                    }
                    buffer.append(value);
                    if (quote) {
                        buffer.append('\u201d');
                    }
                }
                addSeparator = true;
            }
            buffer.append(']');
        }
    }
}

