/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.converter.ConversionException;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Length;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.TransformationAccuracy;
import org.apache.sis.internal.metadata.VerticalDatumTypes;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.MathTransformParser;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.VerticalInfo;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.Factory;
import org.opengis.util.FactoryException;

class GeodeticObjectParser
extends MathTransformParser
implements Comparator<CoordinateSystemAxis> {
    private static final String[] ToWGS84 = new String[]{"dx", "dy", "dz", "ex", "ey", "ez", "ppm"};
    private final CRSFactory crsFactory;
    private final CSFactory csFactory;
    private final DatumFactory datumFactory;
    private final CoordinateOperationFactory opFactory;
    private final ReferencingServices referencing;
    private final boolean usesCommonUnits;
    private final boolean ignoreAxes;
    private final Transliterator transliterator;
    private final Map<String, Object> properties = new HashMap<String, Object>(4);
    private final Map<CoordinateSystemAxis, Integer> axisOrder = new IdentityHashMap<CoordinateSystemAxis, Integer>(4);
    private transient VerticalCRS verticalCRS;
    private transient VerticalInfo verticalElements;

    public GeodeticObjectParser(Map<String, ?> defaultProperties, ObjectFactory factories, MathTransformFactory mtFactory) {
        super(Symbols.getDefault(), Collections.<String, Element>emptyMap(), null, null, null, mtFactory, (Locale)defaultProperties.get("locale"));
        this.crsFactory = (CRSFactory)factories;
        this.csFactory = (CSFactory)factories;
        this.datumFactory = (DatumFactory)factories;
        this.referencing = ReferencingServices.getInstance();
        this.opFactory = this.referencing.getCoordinateOperationFactory(defaultProperties, mtFactory, this.crsFactory, this.csFactory);
        this.transliterator = Transliterator.DEFAULT;
        this.usesCommonUnits = false;
        this.ignoreAxes = false;
    }

    GeodeticObjectParser(Symbols symbols, Map<String, Element> fragments, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Convention convention, Transliterator transliterator, Locale errorLocale, Map<Class<?>, Factory> factories) {
        super(symbols, fragments, numberFormat, dateFormat, unitFormat, GeodeticObjectParser.getFactory(MathTransformFactory.class, factories), errorLocale);
        this.transliterator = transliterator;
        this.crsFactory = GeodeticObjectParser.getFactory(CRSFactory.class, factories);
        this.csFactory = GeodeticObjectParser.getFactory(CSFactory.class, factories);
        this.datumFactory = GeodeticObjectParser.getFactory(DatumFactory.class, factories);
        this.referencing = ReferencingServices.getInstance();
        this.usesCommonUnits = convention.usesCommonUnits;
        this.ignoreAxes = convention == Convention.WKT1_IGNORE_AXES;
        Factory f = factories.get(CoordinateOperationFactory.class);
        if (f != null) {
            this.opFactory = (CoordinateOperationFactory)f;
        } else {
            this.opFactory = this.referencing.getCoordinateOperationFactory(null, this.mtFactory, this.crsFactory, this.csFactory);
            factories.put(CoordinateOperationFactory.class, this.opFactory);
        }
    }

    static <T extends Factory> T getFactory(Class<T> type, Map<Class<?>, Factory> factories) {
        Factory factory = (Factory)type.cast(factories.get(type));
        if (factory == null) {
            factory = (Factory)DefaultFactories.forBuildin(type);
            factories.put(type, factory);
        }
        return (T)factory;
    }

    @Override
    String getPublicFacade() {
        return "org.apache.sis.referencing.factory.GeodeticObjectFactory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object parseObject(String text, ParsePosition position) throws ParseException {
        Object object;
        block9: {
            try {
                Exception ex;
                block10: {
                    object = super.parseObject(text, position);
                    if (this.verticalElements == null) break block9;
                    ex = null;
                    try {
                        this.verticalElements = this.verticalElements.resolve(this.referencing.getMSLH());
                    }
                    catch (UnsupportedOperationException e) {
                        ex = e;
                    }
                    if (this.verticalElements != null) {
                        try {
                            this.verticalElements = this.verticalElements.complete(this.crsFactory, this.csFactory);
                        }
                        catch (FactoryException e) {
                            if (ex != null) break block10;
                            ex = e;
                        }
                    }
                }
                if (this.verticalElements != null) {
                    this.warning(null, (String)null, Errors.formatInternational((short)168, "VerticalExtent", this.verticalElements.unit), ex);
                }
            }
            finally {
                this.verticalElements = null;
                this.verticalCRS = null;
                this.axisOrder.clear();
                this.properties.clear();
            }
        }
        return object;
    }

    @Override
    final Object parseObject(Element element) throws ParseException {
        Object value = this.parseCoordinateReferenceSystem(element, false);
        if (value != null) {
            return value;
        }
        value = this.parseMathTransform(element, false);
        if (value != null) {
            return value;
        }
        Object object = this.parseAxis(0, element, null, SI.METRE);
        if (object == null && (object = this.parsePrimeMeridian(0, element, false, NonSI.DEGREE_ANGLE)) == null && (object = this.parseDatum(0, element, null)) == null && (object = this.parseEllipsoid(0, element)) == null && (object = this.parseToWGS84(0, element)) == null && (object = this.parseVerticalDatum(0, element, false)) == null && (object = this.parseTimeDatum(0, element)) == null && (object = this.parseParametricDatum(0, element)) == null && (object = this.parseEngineeringDatum(0, element, false)) == null && (object = this.parseImageDatum(0, element)) == null && (object = this.parseOperation(0, element)) == null) {
            throw element.missingOrUnknownComponent("GeodeticCRS");
        }
        return object;
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element element, boolean mandatory) throws ParseException {
        CoordinateReferenceSystem crs = this.parseGeodeticCRS(0, element, 2, null);
        if (crs == null && (crs = this.parseProjectedCRS(0, element, false)) == null && (crs = this.parseVerticalCRS(0, element, false)) == null && (crs = this.parseTimeCRS(0, element, false)) == null && (crs = this.parseParametricCRS(0, element, false)) == null && (crs = this.parseEngineeringCRS(0, element, false)) == null && (crs = this.parseImageCRS(0, element)) == null && (crs = this.parseCompoundCRS(0, element)) == null && (crs = this.parseFittedCS(0, element)) == null && mandatory) {
            throw element.missingOrUnknownComponent("GeodeticCRS");
        }
        return crs;
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element parent, int mode, String keyword) throws ParseException {
        Element element = parent.pullElement(mode, keyword);
        if (element == null) {
            return null;
        }
        CoordinateReferenceSystem crs = this.parseCoordinateReferenceSystem(element, true);
        element.close(this.ignoredElements);
        return crs;
    }

    private static Identifier toIdentifier(Object identifier) {
        return identifier instanceof Identifier[] ? ((Identifier[])identifier)[0] : (Identifier)identifier;
    }

    private Map<String, Object> parseMetadataAndClose(Element parent, String name, IdentifiedObject fallback) throws ParseException {
        Element element;
        this.properties.clear();
        this.properties.put("name", name.isEmpty() && fallback != null ? fallback.getName() : name);
        while ((element = parent.pullElement(1, ID_KEYWORDS)) != null) {
            Identifier[] identifiers;
            String authority;
            String codeSpace = element.pullString("codeSpace");
            String code = element.pullObject("code").toString();
            Object version = element.pullOptional(Object.class);
            Element citation = element.pullElement(1, "Citation");
            if (citation != null) {
                authority = citation.pullString("authority");
                citation.close(this.ignoredElements);
            } else {
                authority = codeSpace;
            }
            Element uri = element.pullElement(1, "URI");
            if (uri != null) {
                uri.pullString("URI");
                uri.close(this.ignoredElements);
            }
            element.close(this.ignoredElements);
            ImmutableIdentifier id = new ImmutableIdentifier(Citations.fromName(authority), codeSpace, code, version != null ? version.toString() : null, null);
            Object previous = this.properties.put("identifiers", id);
            if (previous == null) continue;
            if (previous instanceof Identifier) {
                identifiers = new Identifier[]{(Identifier)previous, id};
            } else {
                identifiers = (Identifier[])previous;
                int n = identifiers.length;
                identifiers = Arrays.copyOf(identifiers, n + 1);
                identifiers[n] = id;
            }
            this.properties.put("identifiers", identifiers);
        }
        if (!parent.isEmpty()) {
            element = parent.pullElement(1, "Scope");
            if (element != null) {
                this.properties.put("scope", element.pullString("scope"));
                element.close(this.ignoredElements);
            }
            DefaultExtent extent = null;
            while ((element = parent.pullElement(1, "Area")) != null) {
                String area = element.pullString("area");
                element.close(this.ignoredElements);
                if (extent == null) {
                    extent = new DefaultExtent(area, null, null, null);
                    continue;
                }
                extent.getGeographicElements().add(new DefaultGeographicDescription(area));
            }
            while ((element = parent.pullElement(1, "BBox")) != null) {
                double southBoundLatitude = element.pullDouble("southBoundLatitude");
                double westBoundLongitude = element.pullDouble("westBoundLongitude");
                double northBoundLatitude = element.pullDouble("northBoundLatitude");
                double eastBoundLongitude = element.pullDouble("eastBoundLongitude");
                element.close(this.ignoredElements);
                if (extent == null) {
                    extent = new DefaultExtent();
                }
                extent.getGeographicElements().add(new DefaultGeographicBoundingBox(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude));
            }
            while ((element = parent.pullElement(1, "VerticalExtent")) != null) {
                double minimum = element.pullDouble("minimum");
                double maximum = element.pullDouble("maximum");
                Unit<Length> unit = this.parseScaledUnit(element, "LengthUnit", SI.METRE);
                element.close(this.ignoredElements);
                if (unit == null) {
                    unit = SI.METRE;
                }
                if (extent == null) {
                    extent = new DefaultExtent();
                }
                this.verticalElements = new VerticalInfo(this.verticalElements, extent, minimum, maximum, unit).resolve(this.verticalCRS);
            }
            while ((element = parent.pullElement(1, "TimeExtent")) != null) {
                if (element.peekValue() instanceof String) {
                    element.pullString("startTime");
                    element.pullString("endTime");
                    element.close(this.ignoredElements);
                    this.warning(parent, element, Errors.formatInternational((short)129, (Object)"TimeExtent[String,String]"), null);
                    continue;
                }
                Date startTime = element.pullDate("startTime");
                Date endTime = element.pullDate("endTime");
                element.close(this.ignoredElements);
                try {
                    DefaultTemporalExtent t = new DefaultTemporalExtent();
                    t.setBounds(startTime, endTime);
                    if (extent == null) {
                        extent = new DefaultExtent();
                    }
                    extent.getTemporalElements().add(t);
                }
                catch (UnsupportedOperationException e) {
                    this.warning(parent, element, null, (Exception)e);
                }
            }
            if (extent != null) {
                this.properties.put("domainOfValidity", extent);
            }
            if ((element = parent.pullElement(1, "Remark")) != null) {
                this.properties.put("remarks", element.pullString("remarks"));
                element.close(this.ignoredElements);
            }
        }
        parent.close(this.ignoredElements);
        return this.properties;
    }

    private Map<String, Object> parseAnchorAndClose(Element element, String name) throws ParseException {
        Element anchor = element.pullElement(1, "Anchor");
        Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
        if (anchor != null) {
            properties.put("anchorPoint", anchor.pullString("anchorDefinition"));
            anchor.close(this.ignoredElements);
        }
        return properties;
    }

    private <Q extends Quantity> Unit<Q> parseScaledUnit(Element parent, String keyword, Unit<Q> baseUnit) throws ParseException {
        Element element = parent.pullElement(1, keyword, "Unit");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        double factor = element.pullDouble("factor");
        Unit<?> unit = Units.multiply(baseUnit, factor);
        Unit<?> verify = this.parseUnitID(element);
        element.close(this.ignoredElements);
        if (verify != null) {
            if (!baseUnit.toSI().equals(verify.toSI())) {
                this.warning(parent, element, Errors.formatInternational((short)222, verify), null);
            } else {
                Unit<?> unit2;
                Unit<?> unit3 = unit;
                unit = verify;
                if (Math.abs(unit3.getConverterTo(unit2).convert(1.0) - 1.0) > 1.0E-13) {
                    this.warning(parent, element, Errors.formatInternational((short)227, verify, factor), null);
                } else {
                    verify = null;
                }
            }
        }
        if (verify == null) {
            try {
                verify = this.parseUnit(name);
            }
            catch (IllegalArgumentException e) {
                this.log(new LogRecord(Level.FINE, e.toString()));
            }
            catch (ParseException e) {
                this.log(new LogRecord(Level.FINE, e.toString()));
            }
            if (verify != null) {
                try {
                    if (Math.abs(verify.getConverterToAny(unit).convert(1.0) - 1.0) > 1.0E-13) {
                        this.warning(parent, element, Errors.formatInternational((short)227, verify, factor), null);
                    }
                }
                catch (ConversionException e) {
                    throw (ParseException)new LocalizedParseException(this.errorLocale, 222, new Object[]{verify}, element.offset).initCause(e);
                }
            }
        }
        return unit;
    }

    private CoordinateSystem parseCoordinateSystem(Element parent, String type, int dimension, boolean isWKT1, Unit<?> defaultUnit, Datum datum) throws ParseException, FactoryException {
        Element element;
        this.axisOrder.clear();
        boolean is3D = dimension >= 3;
        Map<String, Object> csProperties = null;
        if (!isWKT1 && (element = parent.pullElement(1, "CS")) != null) {
            String expected = type;
            type = element.pullVoidElement((String)"type").keyword;
            dimension = element.pullInteger("dimension");
            csProperties = new HashMap<String, Object>(this.parseMetadataAndClose(element, "CS", null));
            if (expected != null && !expected.equalsIgnoreCase(type)) {
                throw new LocalizedParseException(this.errorLocale, 191, new String[]{"CS", type}, element.offset);
            }
            if (dimension <= 0 || dimension > 1000) {
                Object[] args;
                short key;
                if (dimension <= 0) {
                    key = 132;
                    args = new Object[]{"dimension", dimension};
                } else {
                    key = 177;
                    args = new Object[]{dimension};
                }
                throw new LocalizedParseException(this.errorLocale, key, args, element.offset);
            }
            type = type.equalsIgnoreCase("Cartesian") ? "Cartesian" : type.toLowerCase(this.symbols.getLocale());
        }
        CoordinateSystemAxis[] axes = null;
        CoordinateSystemAxis axis = this.parseAxis(type == null ? 2 : 1, parent, type, defaultUnit);
        if (axis != null) {
            ArrayList<CoordinateSystemAxis> list = new ArrayList<CoordinateSystemAxis>(dimension + 2);
            do {
                list.add(axis);
            } while ((axis = this.parseAxis(list.size() < dimension ? 2 : 1, parent, type, defaultUnit)) != null);
            if (!isWKT1 || !this.ignoreAxes) {
                axes = list.toArray(new CoordinateSystemAxis[list.size()]);
                Arrays.sort(axes, this);
            }
        }
        if (axes == null) {
            if (type == null) {
                throw parent.missingComponent("Axis");
            }
            String nx = null;
            String x = null;
            String ny = null;
            String y = null;
            String nz = null;
            String z = null;
            AxisDirection dx = AxisDirection.EAST;
            AxisDirection dy = AxisDirection.NORTH;
            AxisDirection direction = null;
            Unit<?> unit = defaultUnit;
            if (type.equals("Cartesian")) {
                if (!(datum instanceof GeodeticDatum)) {
                    throw parent.missingComponent("Axis");
                }
                if (defaultUnit == null) {
                    throw parent.missingComponent("LengthUnit");
                }
                if (is3D) {
                    return this.referencing.getGeocentricCS(defaultUnit.asType(Length.class));
                }
                nx = "Easting";
                x = "E";
                ny = "Northing";
                y = "N";
                if (dimension >= 3) {
                    z = "h";
                    nz = "Ellipsoidal height";
                    unit = SI.METRE;
                }
            } else if (type.equals("ellipsoidal")) {
                if (defaultUnit == null) {
                    throw parent.missingComponent("AngleUnit");
                }
                if (isWKT1) {
                    nx = "Geodetic longitude";
                    x = "\u03bb";
                    ny = "Geodetic latitude";
                    y = "\u03c6";
                } else {
                    nx = "Geodetic latitude";
                    x = "\u03c6";
                    dx = AxisDirection.NORTH;
                    ny = "Geodetic longitude";
                    y = "\u03bb";
                    dy = AxisDirection.EAST;
                }
                if (dimension >= 3) {
                    direction = AxisDirection.UP;
                    z = "h";
                    nz = "Ellipsoidal height";
                    unit = SI.METRE;
                }
            } else if (type.equals("vertical")) {
                if (defaultUnit == null) {
                    throw parent.missingComponent("Unit");
                }
                z = "h";
                nz = "Height";
                direction = AxisDirection.UP;
                if (datum instanceof VerticalDatum) {
                    VerticalDatumType vt = ((VerticalDatum)datum).getVerticalDatumType();
                    if (vt == VerticalDatumType.GEOIDAL) {
                        nz = "Gravity-related height";
                        z = "H";
                    } else if (vt == VerticalDatumType.DEPTH) {
                        direction = AxisDirection.DOWN;
                        nz = "Depth";
                        z = "D";
                    } else if (vt == VerticalDatumTypes.ELLIPSOIDAL) {
                        nz = "Ellipsoidal height";
                    }
                }
            } else if (type.equals("temporal")) {
                if (defaultUnit == null) {
                    throw parent.missingComponent("TimeUnit");
                }
                direction = AxisDirection.FUTURE;
                nz = "Time";
                z = "t";
            } else if (type.equals("parametric")) {
                if (defaultUnit == null) {
                    throw parent.missingComponent("ParametricUnit");
                }
                direction = AxisDirection.OTHER;
                nz = "Parametric";
                z = "p";
            } else {
                throw parent.missingComponent("Axis");
            }
            int i = 0;
            axes = new CoordinateSystemAxis[dimension];
            if (x != null && i < dimension) {
                axes[i++] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", nx), x, dx, defaultUnit);
            }
            if (y != null && i < dimension) {
                axes[i++] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", ny), y, dy, defaultUnit);
            }
            if (z != null && i < dimension) {
                axes[i++] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", nz), z, direction, unit);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (type != null && !type.isEmpty()) {
            int c = type.codePointAt(0);
            buffer.appendCodePoint(Character.toUpperCase(c)).append(type, Character.charCount(c), type.length()).append(' ');
        }
        String name = AxisDirections.appendTo(buffer.append("CS"), axes);
        if (csProperties == null) {
            csProperties = Collections.singletonMap("name", name);
        } else {
            csProperties.put("name", name);
        }
        if (type == null) {
            return this.referencing.createAbstractCS(csProperties, axes);
        }
        if (type.equals("ellipsoidal")) {
            switch (axes.length) {
                case 2: {
                    return this.csFactory.createEllipsoidalCS(csProperties, axes[0], axes[1]);
                }
                case 3: {
                    return this.csFactory.createEllipsoidalCS(csProperties, axes[0], axes[1], axes[2]);
                }
            }
            dimension = axes.length < 2 ? 2 : 3;
        } else if (type.equals("Cartesian")) {
            switch (axes.length) {
                case 2: {
                    return this.csFactory.createCartesianCS(csProperties, axes[0], axes[1]);
                }
                case 3: {
                    return this.csFactory.createCartesianCS(csProperties, axes[0], axes[1], axes[2]);
                }
            }
            dimension = axes.length < 2 ? 2 : 3;
        } else if (type.equals("affine")) {
            switch (axes.length) {
                case 2: {
                    return this.csFactory.createAffineCS(csProperties, axes[0], axes[1]);
                }
                case 3: {
                    return this.csFactory.createAffineCS(csProperties, axes[0], axes[1], axes[2]);
                }
            }
            dimension = axes.length < 2 ? 2 : 3;
        } else if (type.equals("vertical")) {
            dimension = 1;
            if (axes.length == 1) {
                return this.csFactory.createVerticalCS(csProperties, axes[0]);
            }
        } else if (type.equals("temporal")) {
            dimension = 1;
            if (axes.length == 1) {
                return this.csFactory.createTimeCS(csProperties, axes[0]);
            }
        } else if (type.equals("linear")) {
            dimension = 1;
            if (axes.length == 1) {
                return this.csFactory.createLinearCS(csProperties, axes[0]);
            }
        } else if (type.equals("polar")) {
            dimension = 2;
            if (axes.length == 2) {
                return this.csFactory.createPolarCS(csProperties, axes[0], axes[1]);
            }
        } else if (type.equals("cylindrical")) {
            dimension = 3;
            if (axes.length == 3) {
                return this.csFactory.createCylindricalCS(csProperties, axes[0], axes[1], axes[2]);
            }
        } else if (type.equals("spherical")) {
            dimension = 3;
            if (axes.length == 3) {
                return this.csFactory.createSphericalCS(csProperties, axes[0], axes[1], axes[2]);
            }
        } else if (type.equals("parametric")) {
            dimension = 1;
            if (axes.length == 1) {
                return this.referencing.createParametricCS(csProperties, axes[0], this.csFactory);
            }
        } else {
            this.warning(parent, "CS", Errors.formatInternational((short)118, (Object)type), null);
            return this.referencing.createAbstractCS(csProperties, axes);
        }
        throw new LocalizedParseException(this.errorLocale, axes.length > dimension ? (short)149 : 148, new Object[]{dimension, "Axis"}, parent.offset);
    }

    private CoordinateSystemAxis parseAxis(int mode, Element parent, String csType, Unit<?> defaultUnit) throws ParseException {
        CoordinateSystemAxis axis;
        String abbreviation;
        int start;
        int end;
        Element element = parent.pullElement(mode, "Axis");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Element orientation = element.pullVoidElement("orientation");
        Unit<?> unit = this.parseUnit(element);
        if (unit == null) {
            if (defaultUnit == null) {
                throw element.missingComponent("Unit");
            }
            unit = defaultUnit;
        }
        AxisDirection direction = Types.forCodeName(AxisDirection.class, orientation.keyword, true);
        Element meridian = element.pullElement(1, "Meridian");
        if (meridian != null) {
            double angle = meridian.pullDouble("meridian");
            Unit<Angle> m = this.parseScaledUnit(meridian, "AngleUnit", SI.RADIAN);
            meridian.close(this.ignoredElements);
            if (m != null) {
                angle = m.getConverterTo(NonSI.DEGREE_ANGLE).convert(angle);
            }
            direction = this.referencing.directionAlongMeridian(direction, angle);
        }
        if ((end = name.length() - 1) > 1 && name.charAt(end) == ')' && (start = name.lastIndexOf(40, end - 1)) >= 0) {
            int np = end;
            while (--np >= 0 && name.charAt(np) == ')') {
                int c = name.lastIndexOf(40, start - 1);
                if (c < 0) {
                    this.warning(parent, element, Errors.formatInternational((short)79, Character.valueOf('('), name), null);
                    break;
                }
                start = c;
            }
            abbreviation = CharSequences.trimWhitespaces(name.substring(start + 1, end));
            if ((name = CharSequences.trimWhitespaces(name.substring(0, start))).isEmpty()) {
                name = abbreviation;
            }
        } else {
            abbreviation = AxisDirections.suggestAbbreviation(name, direction, unit);
        }
        name = this.transliterator.toLongAxisName(csType, direction, name);
        abbreviation = this.transliterator.toUnicodeAbbreviation(csType, direction, abbreviation);
        Element order = element.pullElement(1, "Order");
        Integer n = null;
        if (order != null) {
            n = order.pullInteger("order");
            order.close(this.ignoredElements);
        }
        try {
            axis = this.csFactory.createCoordinateSystemAxis(this.parseMetadataAndClose(element, name, null), abbreviation, direction, unit);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
        if (this.axisOrder.put(axis, n) != null) {
            throw new LocalizedParseException(this.errorLocale, 16, new Object[]{"Axis[\u201c" + name + "\u201d]"}, element.offset);
        }
        return axis;
    }

    @Override
    public final int compare(CoordinateSystemAxis o1, CoordinateSystemAxis o2) {
        Integer n1 = this.axisOrder.get(o1);
        Integer n2 = this.axisOrder.get(o2);
        if (n1 != null) {
            if (n2 != null) {
                return n1 - n2;
            }
            return -1;
        }
        if (n2 != null) {
            return 1;
        }
        return 0;
    }

    private PrimeMeridian parsePrimeMeridian(int mode, Element parent, boolean isWKT1, Unit<Angle> angularUnit) throws ParseException {
        Element element;
        if (isWKT1 && this.usesCommonUnits) {
            angularUnit = NonSI.DEGREE_ANGLE;
        }
        if ((element = parent.pullElement(mode, "PrimeMeridian", "PrimeM")) == null) {
            return null;
        }
        String name = element.pullString("name");
        double longitude = element.pullDouble("longitude");
        Unit<Angle> unit = this.parseScaledUnit(element, "AngleUnit", SI.RADIAN);
        if (unit != null) {
            angularUnit = unit;
        } else if (angularUnit == null) {
            throw parent.missingComponent("AngleUnit");
        }
        try {
            return this.datumFactory.createPrimeMeridian(this.parseMetadataAndClose(element, name, null), longitude, angularUnit);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private Object parseToWGS84(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "ToWGS84");
        if (element == null) {
            return null;
        }
        double[] values = new double[ToWGS84.length];
        int i = 0;
        while (i < values.length) {
            values[i] = element.pullDouble(ToWGS84[i]);
            if (++i % 3 != 0 || !element.isEmpty()) continue;
        }
        element.close(this.ignoredElements);
        return this.referencing.createToWGS84(values);
    }

    private Ellipsoid parseEllipsoid(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "Ellipsoid", "Spheroid");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        double semiMajorAxis = element.pullDouble("semiMajorAxis");
        double inverseFlattening = element.pullDouble("inverseFlattening");
        Unit<Length> unit = this.parseScaledUnit(element, "LengthUnit", SI.METRE);
        if (unit == null) {
            unit = SI.METRE;
        }
        Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
        try {
            if (inverseFlattening == 0.0) {
                return this.datumFactory.createEllipsoid(properties, semiMajorAxis, semiMajorAxis, unit);
            }
            return this.datumFactory.createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, unit);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private static int getSourceDimensions(OperationMethod method) {
        Integer dimension;
        if (method != null && (dimension = method.getSourceDimensions()) != null) {
            return dimension;
        }
        return 2;
    }

    private OperationMethod parseMethod(Element parent, String ... keywords) throws ParseException {
        Element element = parent.pullElement(2, keywords);
        String name = element.pullString("method");
        Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
        Identifier id = GeodeticObjectParser.toIdentifier(properties.remove("identifiers"));
        FactoryException suppressed = null;
        if (id instanceof ReferenceIdentifier) {
            try {
                return this.referencing.getOperationMethod(this.opFactory, this.mtFactory, ((ReferenceIdentifier)id).getCodeSpace() + ':' + id.getCode());
            }
            catch (FactoryException e) {
                suppressed = e;
            }
        }
        try {
            return this.referencing.getOperationMethod(this.opFactory, this.mtFactory, name);
        }
        catch (FactoryException e) {
            if (suppressed != null) {
                // empty if block
            }
            throw element.parseFailed(e);
        }
    }

    private Conversion parseDerivingConversion(int mode, Element parent, String wrapper, Unit<?> defaultUnit, Unit<Angle> defaultAngularUnit) throws ParseException {
        String name;
        if (wrapper == null) {
            name = null;
        } else {
            if ((parent = parent.pullElement(mode, wrapper)) == null) {
                return null;
            }
            name = parent.pullString("name");
        }
        OperationMethod method = this.parseMethod(parent, "Method", "Projection");
        Map<String, Object> properties = this.properties;
        ParameterValueGroup parameters = method.getParameters().createValue();
        this.parseParameters(parent, parameters, defaultUnit, defaultAngularUnit);
        if (wrapper != null) {
            properties = this.parseMetadataAndClose(parent, name, method);
        }
        try {
            return this.opFactory.createDefiningConversion(properties, method, parameters);
        }
        catch (FactoryException exception) {
            throw parent.parseFailed(exception);
        }
    }

    private GeodeticDatum parseDatum(int mode, Element parent, PrimeMeridian meridian) throws ParseException {
        Element element = parent.pullElement(mode, "Datum", "GeodeticDatum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Ellipsoid ellipsoid = this.parseEllipsoid(2, element);
        Object toWGS84 = this.parseToWGS84(1, element);
        Map<String, Object> properties = this.parseAnchorAndClose(element, name);
        if (meridian == null) {
            meridian = this.referencing.getGreenwich();
        }
        if (toWGS84 != null) {
            properties.put("bursaWolf", toWGS84);
        }
        try {
            return this.datumFactory.createGeodeticDatum(properties, ellipsoid, meridian);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private VerticalDatum parseVerticalDatum(int mode, Element parent, boolean isWKT1) throws ParseException {
        Element element = parent.pullElement(mode, "VerticalDatum", "VDatum", "Vert_Datum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        VerticalDatumType type = null;
        if (isWKT1) {
            type = VerticalDatumTypes.fromLegacy(element.pullInteger("datum"));
        }
        if (type == null) {
            type = VerticalDatumTypes.guess(name, null, null);
        }
        try {
            return this.datumFactory.createVerticalDatum(this.parseAnchorAndClose(element, name), type);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private TemporalDatum parseTimeDatum(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "TimeDatum", "TDatum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Element origin = element.pullElement(2, "TimeOrigin");
        Date epoch = origin.pullDate("origin");
        origin.close(this.ignoredElements);
        try {
            return this.datumFactory.createTemporalDatum(this.parseAnchorAndClose(element, name), epoch);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private Datum parseParametricDatum(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "ParametricDatum", "PDatum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        try {
            return this.referencing.createParametricDatum(this.parseAnchorAndClose(element, name), this.datumFactory);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private EngineeringDatum parseEngineeringDatum(int mode, Element parent, boolean isWKT1) throws ParseException {
        Element element = parent.pullElement(mode, "EngineeringDatum", "EDatum", "Local_Datum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        if (isWKT1) {
            element.pullInteger("datum");
        }
        try {
            return this.datumFactory.createEngineeringDatum(this.parseAnchorAndClose(element, name));
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private ImageDatum parseImageDatum(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "ImageDatum", "IDatum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        PixelInCell pixelInCell = Types.forCodeName(PixelInCell.class, element.pullVoidElement((String)"pixelInCell").keyword, true);
        try {
            return this.datumFactory.createImageDatum(this.parseAnchorAndClose(element, name), pixelInCell);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private SingleCRS parseEngineeringCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        String[] stringArray;
        if (isBaseCRS) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseEngCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "EngineeringCRS";
            stringArray3[1] = "EngCRS";
            stringArray = stringArray3;
            stringArray3[2] = "Local_CS";
        }
        Element element = parent.pullElement(mode, stringArray);
        if (element == null) {
            return null;
        }
        boolean isWKT1 = element.getKeywordIndex() == 2;
        String name = element.pullString("name");
        Unit<?> unit = this.parseUnit(element);
        EngineeringDatum datum = null;
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isWKT1 && !isBaseCRS && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", unit, null)) != null && (baseCRS = this.parseEngineeringCRS(1, element, true)) == null && (baseCRS = this.parseGeodeticCRS(1, element, GeodeticObjectParser.getSourceDimensions(fromBase.getMethod()), "ellipsoidal")) == null) {
            baseCRS = this.parseProjectedCRS(2, element, true);
        }
        if (baseCRS == null) {
            datum = this.parseEngineeringDatum(2, element, isWKT1);
        }
        try {
            CoordinateSystem cs = this.parseCoordinateSystem(element, null, 1, isWKT1, unit, datum);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, datum);
            if (baseCRS != null) {
                return this.crsFactory.createDerivedCRS(properties, baseCRS, fromBase, cs);
            }
            return this.crsFactory.createEngineeringCRS(properties, datum, cs);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private ImageCRS parseImageCRS(int mode, Element parent) throws ParseException {
        CoordinateSystem cs;
        Element element = parent.pullElement(mode, "ImageCRS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        ImageDatum datum = this.parseImageDatum(2, element);
        Unit<?> unit = this.parseUnit(element);
        try {
            cs = this.parseCoordinateSystem(element, "Cartesian", 2, false, unit, datum);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, datum);
            if (cs instanceof AffineCS) {
                return this.crsFactory.createImageCRS(properties, datum, (AffineCS)cs);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
        throw element.illegalCS(cs);
    }

    private SingleCRS parseGeodeticCRS(int mode, Element parent, int dimension, String csType) throws ParseException {
        CoordinateSystem cs;
        Unit<Angle> angularUnit;
        Unit<Object> csUnit;
        boolean isWKT1;
        String[] stringArray;
        if (csType != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "BaseGeodCRS";
            stringArray = stringArray2;
            stringArray2[1] = "GeogCS";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "GeodeticCRS";
            stringArray3[1] = "GeogCS";
            stringArray3[2] = "GeodCRS";
            stringArray = stringArray3;
            stringArray3[3] = "GeocCS";
        }
        Element element = parent.pullElement(mode, stringArray);
        if (element == null) {
            return null;
        }
        switch (element.getKeywordIndex()) {
            default: {
                isWKT1 = false;
                csUnit = this.parseUnit(element);
                if (Units.isAngular(csUnit)) {
                    angularUnit = csUnit.asType(Angle.class);
                    break;
                }
                angularUnit = NonSI.DEGREE_ANGLE;
                if (csUnit != null || !"ellipsoidal".equals(csType)) break;
                csUnit = NonSI.DEGREE_ANGLE;
                break;
            }
            case 1: {
                isWKT1 = true;
                csType = "ellipsoidal";
                angularUnit = this.parseScaledUnit(element, "AngleUnit", SI.RADIAN);
                csUnit = angularUnit;
                dimension = 2;
                break;
            }
            case 3: {
                isWKT1 = true;
                csType = "Cartesian";
                angularUnit = NonSI.DEGREE_ANGLE;
                csUnit = this.parseScaledUnit(element, "LengthUnit", SI.METRE);
                dimension = 3;
            }
        }
        String name = element.pullString("name");
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isWKT1 && csType == null && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", csUnit, angularUnit)) != null) {
            baseCRS = this.parseGeodeticCRS(2, element, GeodeticObjectParser.getSourceDimensions(fromBase.getMethod()), "ellipsoidal");
        }
        try {
            cs = this.parseCoordinateSystem(element, csType, dimension, isWKT1, csUnit, null);
            if (baseCRS != null) {
                Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
                return this.crsFactory.createDerivedCRS(properties, baseCRS, fromBase, cs);
            }
            Unit<Angle> longitudeUnit = AxisDirections.getAngularUnit(cs, angularUnit);
            if (angularUnit != null && !angularUnit.equals(longitudeUnit)) {
                this.warning(element, "AngleUnit", Errors.formatInternational((short)222, angularUnit), null);
            }
            PrimeMeridian meridian = this.parsePrimeMeridian(1, element, isWKT1, longitudeUnit);
            GeodeticDatum datum = this.parseDatum(2, element, meridian);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, datum);
            if (cs instanceof EllipsoidalCS) {
                return this.crsFactory.createGeographicCRS(properties, datum, (EllipsoidalCS)cs);
            }
            if (cs instanceof CartesianCS) {
                return this.crsFactory.createGeocentricCRS(properties, datum, this.referencing.upgradeGeocentricCS((CartesianCS)cs));
            }
            if (cs instanceof SphericalCS) {
                return this.crsFactory.createGeocentricCRS(properties, datum, (SphericalCS)cs);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
        throw element.illegalCS(cs);
    }

    private SingleCRS parseVerticalCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        CoordinateSystem cs;
        String[] stringArray;
        if (isBaseCRS) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseVertCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "VerticalCRS";
            stringArray3[1] = "VertCRS";
            stringArray = stringArray3;
            stringArray3[2] = "Vert_CS";
        }
        Element element = parent.pullElement(mode, stringArray);
        if (element == null) {
            return null;
        }
        boolean isWKT1 = element.getKeywordIndex() == 2;
        String name = element.pullString("name");
        Unit<?> unit = this.parseUnit(element);
        VerticalDatum datum = null;
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isWKT1 && !isBaseCRS && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", unit, null)) != null) {
            baseCRS = this.parseVerticalCRS(2, element, true);
        }
        if (baseCRS == null) {
            datum = this.parseVerticalDatum(2, element, isWKT1);
        }
        try {
            cs = this.parseCoordinateSystem(element, "vertical", 1, isWKT1, unit, datum);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, datum);
            if (cs instanceof VerticalCS) {
                VerticalDatumType type;
                if (baseCRS != null) {
                    return this.crsFactory.createDerivedCRS(properties, baseCRS, fromBase, cs);
                }
                if (VerticalDatumType.OTHER_SURFACE.equals(datum.getVerticalDatumType()) && !VerticalDatumType.OTHER_SURFACE.equals(type = VerticalDatumTypes.guess(datum.getName().getCode(), datum.getAlias(), cs.getAxis(0)))) {
                    datum = this.datumFactory.createVerticalDatum(this.referencing.getProperties(datum), type);
                }
                this.verticalCRS = this.crsFactory.createVerticalCRS(properties, datum, (VerticalCS)cs);
                if (this.verticalElements != null) {
                    this.verticalElements = this.verticalElements.resolve(this.verticalCRS);
                }
                return this.verticalCRS;
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
        throw element.illegalCS(cs);
    }

    private SingleCRS parseTimeCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        CoordinateSystem cs;
        Element element = parent.pullElement(mode, isBaseCRS ? "BaseTimeCRS" : "TimeCRS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Unit<Duration> unit = this.parseScaledUnit(element, "TimeUnit", SI.SECOND);
        TemporalDatum datum = null;
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isBaseCRS && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", unit, null)) != null) {
            baseCRS = this.parseTimeCRS(2, element, true);
        }
        if (baseCRS == null) {
            datum = this.parseTimeDatum(2, element);
        }
        try {
            cs = this.parseCoordinateSystem(element, "temporal", 1, false, unit, datum);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, datum);
            if (cs instanceof TimeCS) {
                if (baseCRS != null) {
                    return this.crsFactory.createDerivedCRS(properties, baseCRS, fromBase, cs);
                }
                return this.crsFactory.createTemporalCRS(properties, datum, (TimeCS)cs);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
        throw element.illegalCS(cs);
    }

    private SingleCRS parseParametricCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        CoordinateSystem cs;
        Element element = parent.pullElement(mode, isBaseCRS ? "BaseParamCRS" : "ParametricCRS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Unit<?> unit = this.parseUnit(element);
        Datum datum = null;
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isBaseCRS && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", unit, null)) != null) {
            baseCRS = this.parseParametricCRS(2, element, true);
        }
        if (baseCRS == null) {
            datum = this.parseParametricDatum(2, element);
        }
        try {
            cs = this.parseCoordinateSystem(element, "parametric", 1, false, unit, datum);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, datum);
            if (cs != null) {
                if (baseCRS != null) {
                    return this.crsFactory.createDerivedCRS(properties, baseCRS, fromBase, cs);
                }
                return this.referencing.createParametricCRS(properties, datum, cs, this.crsFactory);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
        throw element.illegalCS(cs);
    }

    private ProjectedCRS parseProjectedCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        CoordinateSystem cs;
        Unit<Angle> angularUnit;
        Unit<Length> linearUnit;
        String[] stringArray;
        if (isBaseCRS) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseProjCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "ProjectedCRS";
            stringArray3[1] = "ProjCRS";
            stringArray = stringArray3;
            stringArray3[2] = "ProjCS";
        }
        Element element = parent.pullElement(mode, stringArray);
        if (element == null) {
            return null;
        }
        boolean isWKT1 = element.getKeywordIndex() == 2;
        String name = element.pullString("name");
        SingleCRS geoCRS = this.parseGeodeticCRS(2, element, 2, "ellipsoidal");
        if (!(geoCRS instanceof GeographicCRS)) {
            throw new LocalizedParseException(this.errorLocale, 194, new Object[]{geoCRS.getClass()}, element.offset);
        }
        Unit<Length> csUnit = this.parseScaledUnit(element, "LengthUnit", SI.METRE);
        if (isWKT1 && this.usesCommonUnits) {
            linearUnit = SI.METRE;
            angularUnit = NonSI.DEGREE_ANGLE;
        } else {
            linearUnit = csUnit;
            angularUnit = AxisDirections.getAngularUnit(geoCRS.getCoordinateSystem(), NonSI.DEGREE_ANGLE);
        }
        Conversion conversion = this.parseDerivingConversion(2, element, isWKT1 ? null : "Conversion", linearUnit, angularUnit);
        if (csUnit == null && isBaseCRS) {
            csUnit = SI.METRE;
        }
        try {
            cs = this.parseCoordinateSystem(element, "Cartesian", 2, isWKT1, csUnit, geoCRS.getDatum());
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, conversion);
            if (cs instanceof CartesianCS) {
                return this.crsFactory.createProjectedCRS(properties, (GeographicCRS)geoCRS, conversion, (CartesianCS)cs);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
        throw element.illegalCS(cs);
    }

    private CoordinateReferenceSystem parseCompoundCRS(int mode, Element parent) throws ParseException {
        CoordinateReferenceSystem crs;
        Element element = parent.pullElement(mode, "CompoundCRS", "Compd_CS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        ArrayList<CoordinateReferenceSystem> components = new ArrayList<CoordinateReferenceSystem>(4);
        while ((crs = this.parseCoordinateReferenceSystem(element, components.size() < 2)) != null) {
            components.add(crs);
        }
        try {
            return this.referencing.createCompoundCRS(this.crsFactory, this.csFactory, this.parseMetadataAndClose(element, name, null), components.toArray(new CoordinateReferenceSystem[components.size()]));
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private DerivedCRS parseFittedCS(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "Fitted_CS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        MathTransform toBase = this.parseMathTransform(element, true);
        OperationMethod method = this.getOperationMethod();
        CoordinateReferenceSystem baseCRS = this.parseCoordinateReferenceSystem(element, true);
        if (!(baseCRS instanceof SingleCRS)) {
            throw new LocalizedParseException(this.errorLocale, 191, new Object[]{"Fitted_CS", baseCRS.getClass()}, element.offset);
        }
        CoordinateSystemAxis[] axes = new CoordinateSystemAxis[toBase.getSourceDimensions()];
        StringBuilder buffer = new StringBuilder(name).append(" axis ");
        int start = buffer.length();
        try {
            for (int i = 0; i < axes.length; ++i) {
                String number = String.valueOf(i);
                buffer.setLength(start);
                buffer.append(number);
                axes[i] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", buffer.toString()), number, AxisDirection.OTHER, Unit.ONE);
            }
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, baseCRS);
            CoordinateSystem derivedCS = this.referencing.createAbstractCS(Collections.singletonMap("name", AxisDirections.appendTo(new StringBuilder("CS"), axes)), axes);
            properties.put("conversion.name", name);
            return this.referencing.createDerivedCRS(properties, (SingleCRS)baseCRS, method, toBase.inverse(), derivedCS);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
        catch (NoninvertibleTransformException exception) {
            throw element.parseFailed(exception);
        }
    }

    private CoordinateOperation parseOperation(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "CoordinateOperation");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        CoordinateReferenceSystem sourceCRS = this.parseCoordinateReferenceSystem(element, 2, "SourceCRS");
        CoordinateReferenceSystem targetCRS = this.parseCoordinateReferenceSystem(element, 2, "TargetCRS");
        CoordinateReferenceSystem interpolationCRS = this.parseCoordinateReferenceSystem(element, 1, "InterpolationCRS");
        OperationMethod method = this.parseMethod(element, "Method");
        Element accuracy = element.pullElement(1, "OperationAccuracy");
        Map<String, Object> properties = this.parseMetadataAndClose(element, name, method);
        ParameterValueGroup parameters = method.getParameters().createValue();
        this.parseParameters(element, parameters, null, null);
        properties.put("parameters", parameters);
        if (accuracy != null) {
            properties.put("coordinateOperationAccuracy", TransformationAccuracy.create(accuracy.pullDouble("accuracy")));
            accuracy.close(this.ignoredElements);
        }
        try {
            return this.referencing.createSingleOperation(properties, sourceCRS, targetCRS, interpolationCRS, method, this.opFactory);
        }
        catch (FactoryException e) {
            throw element.parseFailed(e);
        }
    }
}

